/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.prometheus.rule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Rules {
    private static final Logger LOG = LoggerFactory.getLogger(Rule.class);

    public static List<Rule> loadRules(String path) throws ModuleStartException {
        return Rules.loadRules(path, Collections.emptyList());
    }

    public static List<Rule> loadRules(String path, List<String> enabledRules) throws ModuleStartException {
        File[] rules;
        try {
            rules = ResourceUtils.getPathFiles((String)path);
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Load fetcher rules failed", (Throwable)e);
        }
        return Arrays.stream(rules).filter(File::isFile).map(f -> {
            try (FileReader r = new FileReader((File)f);){
                String fileName = f.getName();
                int dotIndex = fileName.lastIndexOf(46);
                String string = fileName = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
                if (!enabledRules.contains(fileName)) {
                    Rule rule2 = null;
                    return rule2;
                }
                Rule rule3 = (Rule)new Yaml().loadAs((Reader)r, Rule.class);
                rule3.setName(fileName);
                Rule rule = rule3;
                return rule;
            }
            catch (IOException e) {
                LOG.debug("Reading file {} failed", f, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

