/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.k8s;

import com.google.common.base.Strings;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1ServiceStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.library.kubernetes.KubernetesPodListener;
import org.apache.skywalking.library.kubernetes.KubernetesPodWatcher;
import org.apache.skywalking.library.kubernetes.KubernetesServiceListener;
import org.apache.skywalking.library.kubernetes.KubernetesServiceWatcher;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class K8sInfoRegistry
implements KubernetesServiceListener,
KubernetesPodListener {
    private static final K8sInfoRegistry INSTANCE = new K8sInfoRegistry();
    private final Map<String, V1Pod> namePodMap = new ConcurrentHashMap<String, V1Pod>();
    protected final Map<String, V1Service> nameServiceMap = new ConcurrentHashMap<String, V1Service>();
    private final Map<String, String> podServiceMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> ipPodMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> ipServiceMap = new ConcurrentHashMap<String, String>();
    private static final String SEPARATOR = ".";

    public static K8sInfoRegistry getInstance() {
        return INSTANCE;
    }

    public void start() {
        KubernetesPodWatcher.INSTANCE.addListener((KubernetesPodListener)this).start();
        KubernetesServiceWatcher.INSTANCE.addListener((KubernetesServiceListener)this).start();
    }

    public void onServiceAdded(V1Service service) {
        Optional.ofNullable(service.getMetadata()).ifPresent(metadata -> this.nameServiceMap.put(metadata.getName() + SEPARATOR + metadata.getNamespace(), service));
        this.recompose();
    }

    public void onServiceDeleted(V1Service service) {
        Optional.ofNullable(service.getMetadata()).ifPresent(metadata -> this.nameServiceMap.remove(metadata.getName() + SEPARATOR + metadata.getNamespace()));
        Optional.ofNullable(service.getStatus()).map(V1ServiceStatus::getLoadBalancer).filter(Objects::nonNull).map(V1LoadBalancerStatus::getIngress).filter(CollectionUtils::isNotEmpty).ifPresent(l -> l.stream().filter(i -> StringUtil.isNotEmpty((String)i.getIp())).forEach(i -> this.ipServiceMap.remove(i.getIp())));
        Optional.ofNullable(service.getSpec()).map(V1ServiceSpec::getClusterIPs).filter(CollectionUtils::isNotEmpty).ifPresent(l -> l.stream().filter(StringUtil::isNotEmpty).forEach(this.ipServiceMap::remove));
        this.recompose();
    }

    public void onServiceUpdated(V1Service oldService, V1Service newService) {
        this.onServiceAdded(newService);
    }

    public void onPodAdded(V1Pod pod) {
        Optional.ofNullable(pod.getMetadata()).ifPresent(metadata -> this.namePodMap.put(metadata.getName() + SEPARATOR + metadata.getNamespace(), pod));
        this.recompose();
    }

    public void onPodDeleted(V1Pod pod) {
        Optional.ofNullable(pod.getMetadata()).ifPresent(metadata -> this.namePodMap.remove(metadata.getName() + SEPARATOR + metadata.getNamespace()));
        Optional.ofNullable(pod.getMetadata()).ifPresent(metadata -> this.podServiceMap.remove(metadata.getName() + SEPARATOR + metadata.getNamespace()));
        Optional.ofNullable(pod.getStatus()).filter(s -> StringUtil.isNotEmpty((String)s.getPodIP())).ifPresent(status -> this.ipPodMap.remove(status.getPodIP()));
    }

    public void onPodUpdated(V1Pod oldPod, V1Pod newPod) {
        this.onPodAdded(newPod);
    }

    private void recompose() {
        this.namePodMap.forEach((podName, pod) -> {
            if (!Objects.isNull(pod.getMetadata())) {
                Optional.ofNullable(pod.getStatus()).filter(s -> StringUtil.isNotEmpty((String)s.getPodIP())).ifPresent(status -> this.ipPodMap.put(status.getPodIP(), (String)podName));
            }
            this.nameServiceMap.forEach((serviceName, service) -> {
                if (Objects.isNull(pod.getMetadata()) || Objects.isNull(service.getMetadata()) || Objects.isNull(service.getSpec())) {
                    return;
                }
                Map selector = service.getSpec().getSelector();
                Map labels = pod.getMetadata().getLabels();
                if (Objects.isNull(labels) || Objects.isNull(selector)) {
                    return;
                }
                String podNamespace = pod.getMetadata().getNamespace();
                String serviceNamespace = service.getMetadata().getNamespace();
                if (Strings.isNullOrEmpty((String)podNamespace) || Strings.isNullOrEmpty((String)serviceNamespace) || !podNamespace.equals(serviceNamespace)) {
                    return;
                }
                if (this.hasIntersection(selector.entrySet(), labels.entrySet())) {
                    this.podServiceMap.put((String)podName, (String)serviceName);
                }
            });
        });
        this.nameServiceMap.forEach((serviceName, service) -> {
            if (!Objects.isNull(service.getSpec()) && CollectionUtils.isNotEmpty((List)service.getSpec().getClusterIPs())) {
                for (String clusterIP : service.getSpec().getClusterIPs()) {
                    this.ipServiceMap.put(clusterIP, (String)serviceName);
                }
            }
            if (!Objects.isNull(service.getStatus()) && !Objects.isNull(service.getStatus().getLoadBalancer()) && CollectionUtils.isNotEmpty((List)service.getStatus().getLoadBalancer().getIngress())) {
                for (V1LoadBalancerIngress loadBalancerIngress : service.getStatus().getLoadBalancer().getIngress()) {
                    if (!StringUtil.isNotEmpty((String)loadBalancerIngress.getIp())) continue;
                    this.ipServiceMap.put(loadBalancerIngress.getIp(), (String)serviceName);
                }
            }
        });
    }

    public String findServiceName(String namespace, String podName) {
        return this.podServiceMap.get(podName + SEPARATOR + namespace);
    }

    public String findPodByIP(String ip) {
        return this.ipPodMap.get(ip);
    }

    public String findServiceByIP(String ip) {
        return this.ipServiceMap.get(ip);
    }

    private boolean hasIntersection(Collection<?> o, Collection<?> c) {
        Objects.requireNonNull(o);
        Objects.requireNonNull(c);
        for (Object value : o) {
            if (c.contains(value)) continue;
            return false;
        }
        return true;
    }
}

