/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.meter.analyzer.dsl.HistogramType;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;

public class SampleFamilyBuilder {
    private final Sample[] samples;
    private final SampleFamily.RunningContext context;

    SampleFamilyBuilder(Sample[] samples, SampleFamily.RunningContext context) {
        this.samples = samples;
        this.context = context;
    }

    public static SampleFamilyBuilder newBuilder(Sample ... samples) {
        return new SampleFamilyBuilder(samples, SampleFamily.RunningContext.instance());
    }

    public SampleFamilyBuilder histogramType(HistogramType type) {
        this.context.setHistogramType(type);
        return this;
    }

    public SampleFamilyBuilder defaultHistogramBucketUnit(TimeUnit unit) {
        this.context.setDefaultHistogramBucketUnit(unit);
        return this;
    }

    public SampleFamily build() {
        return SampleFamily.build(this.context, this.samples);
    }
}

