/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import groovy.lang.Closure;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.collection.Stream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.meter.analyzer.dsl.DownsamplingType;
import org.apache.skywalking.oap.meter.analyzer.dsl.EntityDescription.EndpointEntityDescription;
import org.apache.skywalking.oap.meter.analyzer.dsl.EntityDescription.EntityDescription;
import org.apache.skywalking.oap.meter.analyzer.dsl.EntityDescription.InstanceEntityDescription;
import org.apache.skywalking.oap.meter.analyzer.dsl.EntityDescription.ProcessRelationEntityDescription;
import org.apache.skywalking.oap.meter.analyzer.dsl.EntityDescription.ServiceEntityDescription;
import org.apache.skywalking.oap.meter.analyzer.dsl.EntityDescription.ServiceRelationEntityDescription;
import org.apache.skywalking.oap.meter.analyzer.dsl.ExpressionParsingContext;
import org.apache.skywalking.oap.meter.analyzer.dsl.HistogramType;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.tagOpt.K8sRetagType;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.ScopeType;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleFamily {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SampleFamily.class);
    public static final SampleFamily EMPTY = new SampleFamily(new Sample[0], RunningContext.EMPTY);
    public final Sample[] samples;
    public final RunningContext context;

    static SampleFamily build(RunningContext ctx, Sample ... samples) {
        Preconditions.checkNotNull((Object)samples);
        Preconditions.checkArgument((samples.length > 0 ? 1 : 0) != 0);
        samples = (Sample[])Arrays.stream(samples).filter((? super T sample) -> !Double.isNaN(sample.getValue())).toArray(Sample[]::new);
        if (samples.length == 0) {
            return EMPTY;
        }
        return new SampleFamily(samples, Optional.ofNullable(ctx).orElseGet(RunningContext::instance));
    }

    public SampleFamily tagEqual(String ... labels) {
        return this.match(labels, (Function2<String, String, Boolean>)(Function2 & Serializable)(x$0, x$1) -> InternalOps.stringComp(x$0, x$1));
    }

    public SampleFamily tagNotEqual(String[] labels) {
        return this.match(labels, (Function2<String, String, Boolean>)(Function2 & Serializable)(sv, lv) -> !InternalOps.stringComp(sv, lv));
    }

    public SampleFamily tagMatch(String[] labels) {
        return this.match(labels, (Function2<String, String, Boolean>)((Function2 & Serializable)String::matches));
    }

    public SampleFamily tagNotMatch(String[] labels) {
        return this.match(labels, (Function2<String, String, Boolean>)(Function2 & Serializable)(sv, lv) -> !sv.matches((String)lv));
    }

    public SampleFamily valueEqual(double compValue) {
        return this.valueMatch(CompType.EQUAL, compValue, (Function3<CompType, Double, Double, Boolean>)(Function3 & Serializable)(x$0, x$1, x$2) -> InternalOps.doubleComp(x$0, x$1, x$2));
    }

    public SampleFamily valueNotEqual(double compValue) {
        return this.valueMatch(CompType.NOT_EQUAL, compValue, (Function3<CompType, Double, Double, Boolean>)(Function3 & Serializable)(x$0, x$1, x$2) -> InternalOps.doubleComp(x$0, x$1, x$2));
    }

    public SampleFamily valueGreater(double compValue) {
        return this.valueMatch(CompType.GREATER, compValue, (Function3<CompType, Double, Double, Boolean>)(Function3 & Serializable)(x$0, x$1, x$2) -> InternalOps.doubleComp(x$0, x$1, x$2));
    }

    public SampleFamily valueGreaterEqual(double compValue) {
        return this.valueMatch(CompType.GREATER_EQUAL, compValue, (Function3<CompType, Double, Double, Boolean>)(Function3 & Serializable)(x$0, x$1, x$2) -> InternalOps.doubleComp(x$0, x$1, x$2));
    }

    public SampleFamily valueLess(double compValue) {
        return this.valueMatch(CompType.LESS, compValue, (Function3<CompType, Double, Double, Boolean>)(Function3 & Serializable)(x$0, x$1, x$2) -> InternalOps.doubleComp(x$0, x$1, x$2));
    }

    public SampleFamily valueLessEqual(double compValue) {
        return this.valueMatch(CompType.LESS_EQUAL, compValue, (Function3<CompType, Double, Double, Boolean>)(Function3 & Serializable)(x$0, x$1, x$2) -> InternalOps.doubleComp(x$0, x$1, x$2));
    }

    public SampleFamily plus(Number number) {
        return this.newValue(v -> v + number.doubleValue());
    }

    public SampleFamily minus(Number number) {
        return this.newValue(v -> v - number.doubleValue());
    }

    public SampleFamily multiply(Number number) {
        return this.newValue(v -> v * number.doubleValue());
    }

    public SampleFamily div(Number number) {
        return this.newValue(v -> v / number.doubleValue());
    }

    public SampleFamily negative() {
        return this.newValue(v -> -v.doubleValue());
    }

    public SampleFamily plus(SampleFamily another) {
        if (this == EMPTY && another == EMPTY) {
            return EMPTY;
        }
        if (this == EMPTY) {
            return another;
        }
        if (another == EMPTY) {
            return this;
        }
        return this.newValue(another, (Function2<Double, Double, Double>)((Function2 & Serializable)Double::sum));
    }

    public SampleFamily minus(SampleFamily another) {
        if (this == EMPTY && another == EMPTY) {
            return EMPTY;
        }
        if (this == EMPTY) {
            return another.negative();
        }
        if (another == EMPTY) {
            return this;
        }
        return this.newValue(another, (Function2<Double, Double, Double>)(Function2 & Serializable)(a, b) -> a - b);
    }

    public SampleFamily multiply(SampleFamily another) {
        if (this == EMPTY || another == EMPTY) {
            return EMPTY;
        }
        return this.newValue(another, (Function2<Double, Double, Double>)(Function2 & Serializable)(a, b) -> a * b);
    }

    public SampleFamily div(SampleFamily another) {
        if (this == EMPTY) {
            return EMPTY;
        }
        if (another == EMPTY) {
            return this.div(0.0);
        }
        return this.newValue(another, (Function2<Double, Double, Double>)(Function2 & Serializable)(a, b) -> a / b);
    }

    public SampleFamily sum(List<String> by) {
        return this.aggregate(by, Double::sum);
    }

    public SampleFamily max(List<String> by) {
        return this.aggregate(by, Double::max);
    }

    public SampleFamily min(List<String> by) {
        return this.aggregate(by, Double::min);
    }

    public SampleFamily avg(List<String> by) {
        ExpressionParsingContext.get().ifPresent(ctx -> ctx.aggregationLabels.addAll(by));
        if (this == EMPTY) {
            return EMPTY;
        }
        if (by == null) {
            double result = Arrays.stream(this.samples).mapToDouble(Sample::getValue).average().orElse(0.0);
            return SampleFamily.build(this.context, InternalOps.newSample(this.samples[0].name, (ImmutableMap<String, String>)ImmutableMap.of(), this.samples[0].timestamp, result));
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).collect(Collectors.groupingBy(it -> InternalOps.getLabels(by, it), Collectors.mapping(UnaryOperator.identity(), Collectors.toList()))).entrySet().stream().map(entry -> InternalOps.newSample(((Sample)((List)entry.getValue()).get(0)).getName(), (ImmutableMap<String, String>)((ImmutableMap)entry.getKey()), ((Sample)((List)entry.getValue()).get(0)).getTimestamp(), ((List)entry.getValue()).stream().mapToDouble(Sample::getValue).average().orElse(0.0))).toArray(Sample[]::new));
    }

    protected SampleFamily aggregate(List<String> by, DoubleBinaryOperator aggregator) {
        ExpressionParsingContext.get().ifPresent(ctx -> ctx.aggregationLabels.addAll(by));
        if (this == EMPTY) {
            return EMPTY;
        }
        if (by == null) {
            double result = Arrays.stream(this.samples).mapToDouble(s -> s.value).reduce(aggregator).orElse(0.0);
            return SampleFamily.build(this.context, InternalOps.newSample(this.samples[0].name, (ImmutableMap<String, String>)ImmutableMap.of(), this.samples[0].timestamp, result));
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).collect(Collectors.groupingBy(it -> InternalOps.getLabels(by, it), Collectors.mapping(UnaryOperator.identity(), Collectors.toList()))).entrySet().stream().map(entry -> InternalOps.newSample(((Sample)((List)entry.getValue()).get(0)).getName(), (ImmutableMap<String, String>)((ImmutableMap)entry.getKey()), ((Sample)((List)entry.getValue()).get(0)).getTimestamp(), ((List)entry.getValue()).stream().mapToDouble(Sample::getValue).reduce(aggregator).orElse(0.0))).toArray(Sample[]::new));
    }

    public SampleFamily increase(String range) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)range) ? 1 : 0) != 0);
        if (this == EMPTY) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).map(sample -> sample.increase(range, (Function2<Double, Long, Double>)(Function2 & Serializable)(lowerBoundValue, unused) -> sample.value - lowerBoundValue)).toArray(Sample[]::new));
    }

    public SampleFamily rate(String range) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)range) ? 1 : 0) != 0);
        if (this == EMPTY) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).map(sample -> sample.increase(range, (Function2<Double, Long, Double>)(Function2 & Serializable)(lowerBoundValue, lowerBoundTime) -> {
            long timeDiff = (sample.timestamp - lowerBoundTime) / 1000L;
            return timeDiff < 1L ? 0.0 : (sample.value - lowerBoundValue) / (double)timeDiff;
        })).toArray(Sample[]::new));
    }

    public SampleFamily irate() {
        if (this == EMPTY) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).map(sample -> sample.increase((Function2<Double, Long, Double>)(Function2 & Serializable)(lowerBoundValue, lowerBoundTime) -> {
            long timeDiff = (sample.timestamp - lowerBoundTime) / 1000L;
            return timeDiff < 1L ? 0.0 : (sample.value - lowerBoundValue) / (double)timeDiff;
        })).toArray(Sample[]::new));
    }

    public SampleFamily tag(Closure<?> cl) {
        if (this == EMPTY) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).map(sample -> {
            Object delegate = new Object();
            Closure c = cl.rehydrate(delegate, sample, delegate);
            HashMap arg = Maps.newHashMap(sample.labels);
            Object r = c.call((Object)arg);
            return sample.toBuilder().labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)Optional.ofNullable(r instanceof Map ? (Map)r : null).orElse(arg))).build();
        }).toArray(Sample[]::new));
    }

    public SampleFamily filter(Closure<Boolean> filter) {
        if (this == EMPTY) {
            return EMPTY;
        }
        Sample[] filtered = (Sample[])Arrays.stream(this.samples).filter((? super T it) -> (Boolean)filter.call(it.labels)).toArray(Sample[]::new);
        if (filtered.length == 0) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, filtered);
    }

    public SampleFamily retagByK8sMeta(String newLabelName, K8sRetagType type, String existingLabelName, String namespaceLabelName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)newLabelName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)existingLabelName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespaceLabelName) ? 1 : 0) != 0);
        if (this == EMPTY) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, type.execute(this.samples, newLabelName, existingLabelName, namespaceLabelName));
    }

    public SampleFamily histogram() {
        return this.histogram("le", this.context.defaultHistogramBucketUnit);
    }

    public SampleFamily histogram(String le) {
        return this.histogram(le, this.context.defaultHistogramBucketUnit);
    }

    public SampleFamily histogram(String le, TimeUnit unit) {
        long scale = unit.toMillis(1L);
        Preconditions.checkArgument((scale > 0L ? 1 : 0) != 0);
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.isHistogram = true;
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        AtomicDouble pre = new AtomicDouble();
        AtomicReference<String> preLe = new AtomicReference<String>("0");
        return SampleFamily.build(this.context, (Sample[])java.util.stream.Stream.concat(Arrays.stream(this.samples).filter((? super T s) -> !s.labels.containsKey((Object)le)), Arrays.stream(this.samples).filter((? super T s) -> s.labels.containsKey((Object)le)).sorted(Comparator.comparingDouble(s -> Double.parseDouble((String)s.labels.get((Object)le)))).map(s -> {
            double r = this.context.histogramType == HistogramType.ORDINARY ? s.value : s.value - pre.get();
            pre.set(s.value);
            ImmutableMap ll = ImmutableMap.builder().putAll(Maps.filterKeys(s.labels, key -> !Objects.equals(key, le))).put((Object)"le", (Object)String.valueOf((long)(Double.parseDouble(this.context.histogramType == HistogramType.ORDINARY ? (String)s.labels.get((Object)le) : (String)preLe.get()) * (double)scale))).build();
            preLe.set((String)s.labels.get((Object)le));
            return InternalOps.newSample(s.name, (ImmutableMap<String, String>)ll, s.timestamp, r);
        })).toArray(Sample[]::new));
    }

    public SampleFamily histogram_percentile(List<Integer> percentiles) {
        Preconditions.checkArgument((percentiles.size() > 0 ? 1 : 0) != 0);
        int[] p = percentiles.stream().mapToInt(i -> i).toArray();
        ExpressionParsingContext.get().ifPresent(ctx -> {
            Preconditions.checkState((boolean)ctx.isHistogram, (Object)"histogram() should be invoked before invoking histogram_percentile()");
            ctx.percentiles = p;
        });
        return this;
    }

    public SampleFamily service(List<String> labelKeys, Layer layer) {
        Preconditions.checkArgument((labelKeys.size() > 0 ? 1 : 0) != 0);
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.scopeType = ScopeType.SERVICE;
            ctx.scopeLabels.addAll(labelKeys);
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.createMeterSamples(new ServiceEntityDescription(labelKeys, layer, "."));
    }

    public SampleFamily service(List<String> labelKeys, String delimiter, Layer layer) {
        Preconditions.checkArgument((labelKeys.size() > 0 ? 1 : 0) != 0);
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.scopeType = ScopeType.SERVICE;
            ctx.scopeLabels.addAll(labelKeys);
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.createMeterSamples(new ServiceEntityDescription(labelKeys, layer, delimiter));
    }

    public SampleFamily instance(List<String> serviceKeys, String serviceDelimiter, List<String> instanceKeys, String instanceDelimiter, Layer layer, Closure<Map<String, String>> propertiesExtractor) {
        Preconditions.checkArgument((serviceKeys.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((instanceKeys.size() > 0 ? 1 : 0) != 0);
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.scopeType = ScopeType.SERVICE_INSTANCE;
            ctx.scopeLabels.addAll(serviceKeys);
            ctx.scopeLabels.addAll(instanceKeys);
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.createMeterSamples(new InstanceEntityDescription(serviceKeys, instanceKeys, layer, serviceDelimiter, instanceDelimiter, propertiesExtractor));
    }

    public SampleFamily instance(List<String> serviceKeys, List<String> instanceKeys, Layer layer) {
        return this.instance(serviceKeys, ".", instanceKeys, ".", layer, null);
    }

    public SampleFamily endpoint(List<String> serviceKeys, List<String> endpointKeys, Layer layer) {
        Preconditions.checkArgument((serviceKeys.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((endpointKeys.size() > 0 ? 1 : 0) != 0);
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.scopeType = ScopeType.ENDPOINT;
            ctx.scopeLabels.addAll(serviceKeys);
            ctx.scopeLabels.addAll(endpointKeys);
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.createMeterSamples(new EndpointEntityDescription(serviceKeys, endpointKeys, layer, "."));
    }

    public SampleFamily serviceRelation(DetectPoint detectPoint, List<String> sourceServiceKeys, List<String> destServiceKeys, Layer layer) {
        Preconditions.checkArgument((sourceServiceKeys.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((destServiceKeys.size() > 0 ? 1 : 0) != 0);
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.scopeType = ScopeType.SERVICE_RELATION;
            ctx.scopeLabels.addAll(sourceServiceKeys);
            ctx.scopeLabels.addAll(destServiceKeys);
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.createMeterSamples(new ServiceRelationEntityDescription(sourceServiceKeys, destServiceKeys, detectPoint, layer, "."));
    }

    public SampleFamily forEach(List<String> array, Closure<Void> each) {
        if (this == EMPTY) {
            return EMPTY;
        }
        return SampleFamily.build(this.context, (Sample[])Arrays.stream(this.samples).map(sample -> {
            HashMap labels = Maps.newHashMap(sample.getLabels());
            for (String element : array) {
                each.call(new Object[]{element, labels});
            }
            return sample.toBuilder().labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)labels)).build();
        }).toArray(Sample[]::new));
    }

    public SampleFamily processRelation(String detectPointKey, List<String> serviceKeys, List<String> instanceKeys, String sourceProcessIdKey, String destProcessIdKey, String componentKey) {
        Preconditions.checkArgument((serviceKeys.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((instanceKeys.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtil.isNotEmpty((String)sourceProcessIdKey));
        Preconditions.checkArgument((boolean)StringUtil.isNotEmpty((String)destProcessIdKey));
        ExpressionParsingContext.get().ifPresent(ctx -> {
            ctx.scopeType = ScopeType.PROCESS_RELATION;
            ctx.scopeLabels.addAll(serviceKeys);
            ctx.scopeLabels.addAll(instanceKeys);
            ctx.scopeLabels.add(detectPointKey);
            ctx.scopeLabels.add(sourceProcessIdKey);
            ctx.scopeLabels.add(destProcessIdKey);
            ctx.scopeLabels.add(componentKey);
        });
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.createMeterSamples(new ProcessRelationEntityDescription(serviceKeys, instanceKeys, sourceProcessIdKey, destProcessIdKey, detectPointKey, componentKey, "."));
    }

    private SampleFamily createMeterSamples(EntityDescription entityDescription) {
        HashMap<MeterEntity, Sample[]> meterSamples = new HashMap<MeterEntity, Sample[]>();
        Arrays.stream(this.samples).collect(Collectors.groupingBy(it -> InternalOps.getLabels(entityDescription.getLabelKeys(), it), Collectors.mapping(UnaryOperator.identity(), Collectors.toList()))).forEach((labels, samples) -> {
            MeterEntity meterEntity = InternalOps.buildMeterEntity(samples, entityDescription);
            meterSamples.put(meterEntity, InternalOps.left(samples, entityDescription.getLabelKeys()));
        });
        this.context.setMeterSamples(meterSamples);
        return SampleFamily.build(this.context, this.samples);
    }

    private SampleFamily match(String[] labels, Function2<String, String, Boolean> op) {
        Preconditions.checkArgument((labels.length % 2 == 0 ? 1 : 0) != 0);
        HashMap<String, String> ll = new HashMap<String, String>(labels.length / 2);
        for (int i = 0; i < labels.length; i += 2) {
            ll.put(labels[i], labels[i + 1]);
        }
        Sample[] ss = (Sample[])Arrays.stream(this.samples).filter((? super T sample) -> ll.entrySet().stream().allMatch(entry -> (Boolean)op.apply(sample.labels.getOrDefault(entry.getKey(), (Object)""), entry.getValue()))).toArray(Sample[]::new);
        return ss.length > 0 ? SampleFamily.build(this.context, ss) : EMPTY;
    }

    private SampleFamily valueMatch(CompType compType, double compValue, Function3<CompType, Double, Double, Boolean> op) {
        Sample[] ss = (Sample[])Arrays.stream(this.samples).filter((? super T sample) -> (Boolean)op.apply((Object)compType, (Object)sample.value, (Object)compValue)).toArray(Sample[]::new);
        return ss.length > 0 ? SampleFamily.build(this.context, ss) : EMPTY;
    }

    SampleFamily newValue(Function<Double, Double> transform) {
        if (this == EMPTY) {
            return EMPTY;
        }
        Sample[] ss = new Sample[this.samples.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.samples[i].newValue(transform);
        }
        return SampleFamily.build(this.context, ss);
    }

    private SampleFamily newValue(SampleFamily another, Function2<Double, Double, Double> transform) {
        Sample[] ss = (Sample[])Arrays.stream(this.samples).flatMap(cs -> Stream.of((Object[])another.samples).find(as -> cs.labels.equals(as.labels)).map(as -> cs.toBuilder().value((Double)transform.apply((Object)cs.value, (Object)as.value))).map(Sample.SampleBuilder::build).toJavaStream()).toArray(Sample[]::new);
        return ss.length > 0 ? SampleFamily.build(this.context, ss) : EMPTY;
    }

    public SampleFamily downsampling(DownsamplingType type) {
        ExpressionParsingContext.get().ifPresent(it -> {
            it.downsampling = type;
        });
        return this;
    }

    @Generated
    private SampleFamily(Sample[] samples, RunningContext context) {
        this.samples = samples;
        this.context = context;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SampleFamily)) {
            return false;
        }
        SampleFamily other = (SampleFamily)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.samples, other.samples)) {
            return false;
        }
        RunningContext this$context = this.context;
        RunningContext other$context = other.context;
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SampleFamily;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.samples);
        RunningContext $context = this.context;
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SampleFamily(samples=" + Arrays.deepToString(this.samples) + ", context=" + this.context + ")";
    }

    private static enum CompType {
        EQUAL,
        NOT_EQUAL,
        LESS,
        LESS_EQUAL,
        GREATER,
        GREATER_EQUAL;

    }

    private static class InternalOps {
        private InternalOps() {
        }

        private static Sample[] left(List<Sample> samples, List<String> labelKeys) {
            return (Sample[])samples.stream().map(s -> {
                ImmutableMap ll = ImmutableMap.builder().putAll(Maps.filterKeys(s.labels, key -> !labelKeys.contains(key))).build();
                return s.toBuilder().labels((ImmutableMap<String, String>)ll).build();
            }).toArray(Sample[]::new);
        }

        private static String dim(List<Sample> samples, List<String> labelKeys, String delimiter) {
            String name = labelKeys.stream().map(k -> (String)((Sample)samples.get((int)0)).labels.getOrDefault(k, (Object)"")).filter(v -> !StringUtil.isEmpty((String)v)).collect(Collectors.joining(StringUtil.isEmpty((String)delimiter) ? "." : delimiter));
            return name;
        }

        private static MeterEntity buildMeterEntity(List<Sample> samples, EntityDescription entityDescription) {
            switch (entityDescription.getScopeType()) {
                case SERVICE: {
                    ServiceEntityDescription serviceEntityDescription = (ServiceEntityDescription)entityDescription;
                    return MeterEntity.newService((String)InternalOps.dim(samples, serviceEntityDescription.getServiceKeys(), serviceEntityDescription.getDelimiter()), (Layer)serviceEntityDescription.getLayer());
                }
                case SERVICE_INSTANCE: {
                    InstanceEntityDescription instanceEntityDescription = (InstanceEntityDescription)entityDescription;
                    Map properties = null;
                    if (instanceEntityDescription.getPropertiesExtractor() != null) {
                        properties = (Map)instanceEntityDescription.getPropertiesExtractor().call(samples.get((int)0).labels);
                    }
                    return MeterEntity.newServiceInstance((String)InternalOps.dim(samples, instanceEntityDescription.getServiceKeys(), instanceEntityDescription.getServiceDelimiter()), (String)InternalOps.dim(samples, instanceEntityDescription.getInstanceKeys(), instanceEntityDescription.getInstanceDelimiter()), (Layer)instanceEntityDescription.getLayer(), (Map)properties);
                }
                case ENDPOINT: {
                    EndpointEntityDescription endpointEntityDescription = (EndpointEntityDescription)entityDescription;
                    return MeterEntity.newEndpoint((String)InternalOps.dim(samples, endpointEntityDescription.getServiceKeys(), endpointEntityDescription.getDelimiter()), (String)InternalOps.dim(samples, endpointEntityDescription.getEndpointKeys(), endpointEntityDescription.getDelimiter()), (Layer)endpointEntityDescription.getLayer());
                }
                case SERVICE_RELATION: {
                    ServiceRelationEntityDescription serviceRelationEntityDescription = (ServiceRelationEntityDescription)entityDescription;
                    return MeterEntity.newServiceRelation((String)InternalOps.dim(samples, serviceRelationEntityDescription.getSourceServiceKeys(), serviceRelationEntityDescription.getDelimiter()), (String)InternalOps.dim(samples, serviceRelationEntityDescription.getDestServiceKeys(), serviceRelationEntityDescription.getDelimiter()), (DetectPoint)serviceRelationEntityDescription.getDetectPoint(), (Layer)serviceRelationEntityDescription.getLayer());
                }
                case PROCESS_RELATION: {
                    ProcessRelationEntityDescription processRelationEntityDescription = (ProcessRelationEntityDescription)entityDescription;
                    String detectPointValue = InternalOps.dim(samples, Collections.singletonList(processRelationEntityDescription.getDetectPointKey()), processRelationEntityDescription.getDelimiter());
                    DetectPoint point = StringUtils.equalsAnyIgnoreCase((CharSequence)detectPointValue, (CharSequence[])new CharSequence[]{"server"}) ? DetectPoint.SERVER : DetectPoint.CLIENT;
                    String componentValue = InternalOps.dim(samples, Collections.singletonList(processRelationEntityDescription.getComponentKey()), processRelationEntityDescription.getDelimiter());
                    int componentId = StringUtil.isNotEmpty((String)componentValue) ? Integer.parseInt(componentValue) : 0;
                    return MeterEntity.newProcessRelation((String)InternalOps.dim(samples, processRelationEntityDescription.getServiceKeys(), processRelationEntityDescription.getDelimiter()), (String)InternalOps.dim(samples, processRelationEntityDescription.getInstanceKeys(), processRelationEntityDescription.getDelimiter()), (String)InternalOps.dim(samples, Collections.singletonList(processRelationEntityDescription.getSourceProcessIdKey()), processRelationEntityDescription.getDelimiter()), (String)InternalOps.dim(samples, Collections.singletonList(processRelationEntityDescription.getDestProcessIdKey()), processRelationEntityDescription.getDelimiter()), (int)componentId, (DetectPoint)point);
                }
            }
            throw new UnexpectedException("Unexpected scope type of entityDescription " + entityDescription);
        }

        private static Sample newSample(String name, ImmutableMap<String, String> labels, long timestamp, double newValue) {
            return Sample.builder().value(newValue).labels(labels).timestamp(timestamp).name(name).build();
        }

        private static boolean stringComp(String a, String b) {
            if (Strings.isNullOrEmpty((String)a) && Strings.isNullOrEmpty((String)b)) {
                return true;
            }
            if (Strings.isNullOrEmpty((String)a)) {
                return false;
            }
            return a.equals(b);
        }

        private static boolean doubleComp(CompType compType, double a, double b) {
            int result = Double.compare(a, b);
            switch (compType) {
                case EQUAL: {
                    return result == 0;
                }
                case NOT_EQUAL: {
                    return result != 0;
                }
                case GREATER: {
                    return result == 1;
                }
                case GREATER_EQUAL: {
                    return result == 0 || result == 1;
                }
                case LESS: {
                    return result == -1;
                }
                case LESS_EQUAL: {
                    return result == 0 || result == -1;
                }
            }
            return false;
        }

        private static ImmutableMap<String, String> getLabels(List<String> labelKeys, Sample sample) {
            return (ImmutableMap)labelKeys.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), labelKey -> (String)sample.labels.getOrDefault(labelKey, (Object)"")));
        }
    }

    public static class RunningContext {
        static RunningContext EMPTY = RunningContext.instance();
        private Map<MeterEntity, Sample[]> meterSamples = new HashMap<MeterEntity, Sample[]>();
        private HistogramType histogramType;
        private TimeUnit defaultHistogramBucketUnit;

        static RunningContext instance() {
            return RunningContext.builder().histogramType(HistogramType.CUMULATIVE).defaultHistogramBucketUnit(TimeUnit.SECONDS).build();
        }

        @Generated
        RunningContext(Map<MeterEntity, Sample[]> meterSamples, HistogramType histogramType, TimeUnit defaultHistogramBucketUnit) {
            this.meterSamples = meterSamples;
            this.histogramType = histogramType;
            this.defaultHistogramBucketUnit = defaultHistogramBucketUnit;
        }

        @Generated
        public static RunningContextBuilder builder() {
            return new RunningContextBuilder();
        }

        @Generated
        public String toString() {
            return "SampleFamily.RunningContext(meterSamples=" + this.getMeterSamples() + ", histogramType=" + (Object)((Object)this.getHistogramType()) + ", defaultHistogramBucketUnit=" + (Object)((Object)this.getDefaultHistogramBucketUnit()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RunningContext)) {
                return false;
            }
            RunningContext other = (RunningContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<MeterEntity, Sample[]> this$meterSamples = this.getMeterSamples();
            Map<MeterEntity, Sample[]> other$meterSamples = other.getMeterSamples();
            if (this$meterSamples == null ? other$meterSamples != null : !((Object)this$meterSamples).equals(other$meterSamples)) {
                return false;
            }
            HistogramType this$histogramType = this.getHistogramType();
            HistogramType other$histogramType = other.getHistogramType();
            if (this$histogramType == null ? other$histogramType != null : !((Object)((Object)this$histogramType)).equals((Object)other$histogramType)) {
                return false;
            }
            TimeUnit this$defaultHistogramBucketUnit = this.getDefaultHistogramBucketUnit();
            TimeUnit other$defaultHistogramBucketUnit = other.getDefaultHistogramBucketUnit();
            return !(this$defaultHistogramBucketUnit == null ? other$defaultHistogramBucketUnit != null : !((Object)((Object)this$defaultHistogramBucketUnit)).equals((Object)other$defaultHistogramBucketUnit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RunningContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<MeterEntity, Sample[]> $meterSamples = this.getMeterSamples();
            result = result * 59 + ($meterSamples == null ? 43 : ((Object)$meterSamples).hashCode());
            HistogramType $histogramType = this.getHistogramType();
            result = result * 59 + ($histogramType == null ? 43 : ((Object)((Object)$histogramType)).hashCode());
            TimeUnit $defaultHistogramBucketUnit = this.getDefaultHistogramBucketUnit();
            result = result * 59 + ($defaultHistogramBucketUnit == null ? 43 : ((Object)((Object)$defaultHistogramBucketUnit)).hashCode());
            return result;
        }

        @Generated
        public Map<MeterEntity, Sample[]> getMeterSamples() {
            return this.meterSamples;
        }

        @Generated
        public HistogramType getHistogramType() {
            return this.histogramType;
        }

        @Generated
        public TimeUnit getDefaultHistogramBucketUnit() {
            return this.defaultHistogramBucketUnit;
        }

        @Generated
        public void setMeterSamples(Map<MeterEntity, Sample[]> meterSamples) {
            this.meterSamples = meterSamples;
        }

        @Generated
        public void setHistogramType(HistogramType histogramType) {
            this.histogramType = histogramType;
        }

        @Generated
        public void setDefaultHistogramBucketUnit(TimeUnit defaultHistogramBucketUnit) {
            this.defaultHistogramBucketUnit = defaultHistogramBucketUnit;
        }

        @Generated
        public static class RunningContextBuilder {
            @Generated
            private Map<MeterEntity, Sample[]> meterSamples;
            @Generated
            private HistogramType histogramType;
            @Generated
            private TimeUnit defaultHistogramBucketUnit;

            @Generated
            RunningContextBuilder() {
            }

            @Generated
            public RunningContextBuilder meterSamples(Map<MeterEntity, Sample[]> meterSamples) {
                this.meterSamples = meterSamples;
                return this;
            }

            @Generated
            public RunningContextBuilder histogramType(HistogramType histogramType) {
                this.histogramType = histogramType;
                return this;
            }

            @Generated
            public RunningContextBuilder defaultHistogramBucketUnit(TimeUnit defaultHistogramBucketUnit) {
                this.defaultHistogramBucketUnit = defaultHistogramBucketUnit;
                return this;
            }

            @Generated
            public RunningContext build() {
                return new RunningContext(this.meterSamples, this.histogramType, this.defaultHistogramBucketUnit);
            }

            @Generated
            public String toString() {
                return "SampleFamily.RunningContext.RunningContextBuilder(meterSamples=" + this.meterSamples + ", histogramType=" + (Object)((Object)this.histogramType) + ", defaultHistogramBucketUnit=" + (Object)((Object)this.defaultHistogramBucketUnit) + ")";
            }
        }
    }
}

