/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.sampling;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.oap.server.analyzer.provider.trace.sampling.SamplingPolicy;
import org.apache.skywalking.oap.server.analyzer.provider.trace.sampling.SamplingPolicySettings;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class SamplingPolicySettingsReader {
    private Map yamlData;

    public SamplingPolicySettingsReader(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        this.yamlData = (Map)yaml.load(inputStream);
    }

    public SamplingPolicySettingsReader(Reader io) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        this.yamlData = (Map)yaml.load(io);
    }

    public SamplingPolicySettings readSettings() {
        SamplingPolicySettings samplingPolicySettings = new SamplingPolicySettings();
        if (Objects.nonNull(this.yamlData)) {
            this.readDefaultSamplingPolicy(samplingPolicySettings);
            this.readServicesSamplingPolicy(samplingPolicySettings);
        }
        return samplingPolicySettings;
    }

    private void readDefaultSamplingPolicy(SamplingPolicySettings samplingPolicySettings) {
        Map objectMap = (Map)this.yamlData.get("default");
        if (objectMap == null) {
            return;
        }
        if (objectMap.get("rate") != null) {
            samplingPolicySettings.getDefaultPolicy().setRate((Integer)objectMap.get("rate"));
        }
        if (objectMap.get("duration") != null) {
            samplingPolicySettings.getDefaultPolicy().setDuration((Integer)objectMap.get("duration"));
        }
    }

    private void readServicesSamplingPolicy(SamplingPolicySettings samplingPolicySettings) {
        Map objectMap = this.yamlData;
        Object servicesObject = objectMap.get("services");
        if (servicesObject != null) {
            List serviceList = (List)servicesObject;
            serviceList.forEach(service -> {
                String name = (String)service.get("name");
                if (StringUtil.isBlank((String)name)) {
                    return;
                }
                SamplingPolicy samplingPolicy = new SamplingPolicy();
                samplingPolicy.setRate(service.get("rate") == null ? null : (Integer)service.get("rate"));
                samplingPolicy.setDuration(service.get("duration") == null ? null : (Integer)service.get("duration"));
                samplingPolicySettings.add(name, samplingPolicy);
            });
        }
    }
}

