/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentReference;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.DBLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListenerFactory;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.CommonAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.DatabaseSlowStatementBuilder;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EndpointSourceBuilder;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EntryAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.ExitAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.LocalAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.RPCTrafficSourceBuilder;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressAliasCache;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.EndpointRelation;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCAnalysisListener
extends CommonAnalysisListener
implements EntryAnalysisListener,
ExitAnalysisListener,
LocalAnalysisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPCAnalysisListener.class);
    private final List<RPCTrafficSourceBuilder> callingInTraffic = new ArrayList<RPCTrafficSourceBuilder>(10);
    private final List<RPCTrafficSourceBuilder> callingOutTraffic = new ArrayList<RPCTrafficSourceBuilder>(10);
    private final List<DatabaseSlowStatementBuilder> dbSlowStatementBuilders = new ArrayList<DatabaseSlowStatementBuilder>(10);
    private final List<EndpointSourceBuilder> logicEndpointBuilders = new ArrayList<EndpointSourceBuilder>(10);
    private final Gson gson = new Gson();
    private final SourceReceiver sourceReceiver;
    private final AnalyzerModuleConfig config;
    private final NetworkAddressAliasCache networkAddressAliasCache;
    private final NamingControl namingControl;

    @Override
    public boolean containsPoint(AnalysisListener.Point point) {
        return AnalysisListener.Point.Entry.equals((Object)point) || AnalysisListener.Point.Exit.equals((Object)point) || AnalysisListener.Point.Local.equals((Object)point);
    }

    @Override
    public void parseEntry(SpanObject span, SegmentObject segmentObject) {
        if (span.getSkipAnalysis()) {
            return;
        }
        if (span.getRefsCount() > 0) {
            for (int i = 0; i < span.getRefsCount(); ++i) {
                SegmentReference reference = span.getRefs(i);
                RPCTrafficSourceBuilder sourceBuilder = new RPCTrafficSourceBuilder(this.namingControl);
                if (StringUtil.isEmpty((String)reference.getParentEndpoint())) {
                    sourceBuilder.setSourceEndpointName("User");
                } else {
                    sourceBuilder.setSourceEndpointName(reference.getParentEndpoint());
                }
                String networkAddressUsedAtPeer = reference.getNetworkAddressUsedAtPeer();
                boolean isMQ = span.getSpanLayer().equals((Object)SpanLayer.MQ);
                if (isMQ || this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(networkAddressUsedAtPeer)) {
                    sourceBuilder.setSourceServiceName(networkAddressUsedAtPeer);
                    sourceBuilder.setSourceEndpointOwnerServiceName(reference.getParentService());
                    sourceBuilder.setSourceServiceInstanceName(networkAddressUsedAtPeer);
                    if (isMQ) {
                        sourceBuilder.setSourceLayer(Layer.VIRTUAL_MQ);
                    } else {
                        sourceBuilder.setSourceLayer(Layer.VIRTUAL_GATEWAY);
                    }
                    sourceBuilder.setSourceEndpointOwnerServiceLayer(Layer.GENERAL);
                } else {
                    sourceBuilder.setSourceServiceName(reference.getParentService());
                    sourceBuilder.setSourceServiceInstanceName(reference.getParentServiceInstance());
                    sourceBuilder.setSourceLayer(Layer.GENERAL);
                }
                sourceBuilder.setDestEndpointName(span.getOperationName());
                sourceBuilder.setDestServiceInstanceName(segmentObject.getServiceInstance());
                sourceBuilder.setDestServiceName(segmentObject.getService());
                sourceBuilder.setDestLayer(this.identifyServiceLayer(span.getSpanLayer()));
                sourceBuilder.setDetectPoint(DetectPoint.SERVER);
                sourceBuilder.setComponentId(span.getComponentId());
                this.setPublicAttrs(sourceBuilder, span);
                this.callingInTraffic.add(sourceBuilder);
            }
        } else {
            RPCTrafficSourceBuilder sourceBuilder = new RPCTrafficSourceBuilder(this.namingControl);
            sourceBuilder.setSourceServiceName("User");
            sourceBuilder.setSourceServiceInstanceName("User");
            sourceBuilder.setSourceEndpointName("User");
            sourceBuilder.setSourceLayer(Layer.UNDEFINED);
            sourceBuilder.setDestServiceInstanceName(segmentObject.getServiceInstance());
            sourceBuilder.setDestServiceName(segmentObject.getService());
            sourceBuilder.setDestLayer(this.identifyServiceLayer(span.getSpanLayer()));
            sourceBuilder.setDestEndpointName(span.getOperationName());
            sourceBuilder.setDetectPoint(DetectPoint.SERVER);
            sourceBuilder.setComponentId(span.getComponentId());
            this.setPublicAttrs(sourceBuilder, span);
            this.callingInTraffic.add(sourceBuilder);
        }
        this.parseLogicEndpoints(span, segmentObject);
    }

    @Override
    public void parseExit(SpanObject span, SegmentObject segmentObject) {
        if (span.getSkipAnalysis()) {
            return;
        }
        RPCTrafficSourceBuilder sourceBuilder = new RPCTrafficSourceBuilder(this.namingControl);
        String networkAddress = span.getPeer();
        if (StringUtil.isEmpty((String)networkAddress)) {
            return;
        }
        sourceBuilder.setSourceServiceName(segmentObject.getService());
        sourceBuilder.setSourceServiceInstanceName(segmentObject.getServiceInstance());
        sourceBuilder.setSourceLayer(this.identifyServiceLayer(span.getSpanLayer()));
        NetworkAddressAlias networkAddressAlias = this.networkAddressAliasCache.get(networkAddress);
        if (networkAddressAlias == null) {
            sourceBuilder.setDestServiceName(networkAddress);
            sourceBuilder.setDestServiceInstanceName(networkAddress);
            sourceBuilder.setDestLayer(this.identifyRemoteServiceLayer(span.getSpanLayer(), span.getPeer()));
        } else {
            IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId((String)networkAddressAlias.getRepresentServiceId());
            IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId((String)networkAddressAlias.getRepresentServiceInstanceId());
            sourceBuilder.setDestServiceName(serviceIDDefinition.getName());
            if (!this.config.shouldIgnorePeerIPDue2Virtual(span.getComponentId())) {
                sourceBuilder.setDestServiceInstanceName(instanceIDDefinition.getName());
            }
            sourceBuilder.setDestLayer(Layer.GENERAL);
        }
        sourceBuilder.setDetectPoint(DetectPoint.CLIENT);
        sourceBuilder.setComponentId(span.getComponentId());
        this.setPublicAttrs(sourceBuilder, span);
        this.callingOutTraffic.add(sourceBuilder);
        if (RequestType.DATABASE.equals((Object)sourceBuilder.getType())) {
            boolean isSlowDBAccess = false;
            DatabaseSlowStatementBuilder slowStatementBuilder = new DatabaseSlowStatementBuilder(this.namingControl);
            slowStatementBuilder.setServiceName(networkAddress);
            slowStatementBuilder.setId(segmentObject.getTraceSegmentId() + "-" + span.getSpanId());
            slowStatementBuilder.setLatency(sourceBuilder.getLatency());
            slowStatementBuilder.setTimeBucket(TimeBucket.getRecordTimeBucket((long)span.getStartTime()));
            slowStatementBuilder.setTraceId(segmentObject.getTraceId());
            for (KeyStringValuePair tag : span.getTagsList()) {
                if ("db.statement".equals(tag.getKey())) {
                    String sqlStatement = tag.getValue();
                    if (!StringUtil.isNotEmpty((String)sqlStatement)) continue;
                    if (sqlStatement.length() > this.config.getMaxSlowSQLLength()) {
                        slowStatementBuilder.setStatement(sqlStatement.substring(0, this.config.getMaxSlowSQLLength()));
                        continue;
                    }
                    slowStatementBuilder.setStatement(sqlStatement);
                    continue;
                }
                if (!"db.type".equals(tag.getKey())) continue;
                String dbType = tag.getValue();
                DBLatencyThresholdsAndWatcher thresholds = this.config.getDbLatencyThresholdsAndWatcher();
                int threshold = thresholds.getThreshold(dbType);
                if (sourceBuilder.getLatency() <= threshold) continue;
                isSlowDBAccess = true;
            }
            if (StringUtil.isEmpty((String)slowStatementBuilder.getStatement())) {
                String statement = StringUtil.isEmpty((String)span.getOperationName()) ? "[No statement]" : "[No statement]/" + span.getOperationName();
                slowStatementBuilder.setStatement(statement);
            }
            if (isSlowDBAccess) {
                this.dbSlowStatementBuilders.add(slowStatementBuilder);
            }
        }
    }

    private void setPublicAttrs(RPCTrafficSourceBuilder sourceBuilder, SpanObject span) {
        long latency = span.getEndTime() - span.getStartTime();
        sourceBuilder.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)span.getStartTime()));
        sourceBuilder.setLatency((int)latency);
        sourceBuilder.setHttpResponseStatusCode(0);
        span.getTagsList().forEach(tag -> {
            String tagKey = tag.getKey();
            if ("status_code".equals(tagKey) || "http.status_code".equals(tagKey)) {
                try {
                    sourceBuilder.setHttpResponseStatusCode(Integer.parseInt(tag.getValue()));
                }
                catch (NumberFormatException e) {
                    log.warn("span {} has illegal status code {}", (Object)span, (Object)tag.getValue());
                }
            } else if ("rpc.status_code".equals(tagKey)) {
                sourceBuilder.setRpcStatusCode(tag.getValue());
            }
            sourceBuilder.setTag((KeyStringValuePair)tag);
        });
        sourceBuilder.setStatus(!span.getIsError());
        switch (span.getSpanLayer()) {
            case Http: {
                sourceBuilder.setType(RequestType.HTTP);
                break;
            }
            case Database: {
                sourceBuilder.setType(RequestType.DATABASE);
                break;
            }
            case MQ: {
                sourceBuilder.setType(RequestType.MQ);
                break;
            }
            default: {
                sourceBuilder.setType(RequestType.RPC);
            }
        }
    }

    @Override
    public void parseLocal(SpanObject span, SegmentObject segmentObject) {
        this.parseLogicEndpoints(span, segmentObject);
    }

    @Override
    public void build() {
        this.callingInTraffic.forEach(callingIn -> {
            callingIn.prepare();
            this.sourceReceiver.receive((ISource)callingIn.toService());
            this.sourceReceiver.receive((ISource)callingIn.toServiceInstance());
            this.sourceReceiver.receive((ISource)callingIn.toServiceRelation());
            this.sourceReceiver.receive((ISource)callingIn.toServiceInstanceRelation());
            if (Layer.FAAS != callingIn.getDestLayer()) {
                this.sourceReceiver.receive((ISource)callingIn.toEndpoint());
                EndpointRelation endpointRelation = callingIn.toEndpointRelation();
                if (endpointRelation != null) {
                    this.sourceReceiver.receive((ISource)endpointRelation);
                }
            }
        });
        this.callingOutTraffic.forEach(callingOut -> {
            callingOut.prepare();
            this.sourceReceiver.receive((ISource)callingOut.toServiceRelation());
            ServiceInstanceRelation serviceInstanceRelation = callingOut.toServiceInstanceRelation();
            if (serviceInstanceRelation != null) {
                this.sourceReceiver.receive((ISource)serviceInstanceRelation);
            }
            if (RequestType.DATABASE.equals((Object)callingOut.getType())) {
                this.sourceReceiver.receive((ISource)callingOut.toServiceMeta());
                this.sourceReceiver.receive((ISource)callingOut.toDatabaseAccess());
            }
        });
        this.dbSlowStatementBuilders.forEach(dbSlowStatBuilder -> {
            dbSlowStatBuilder.prepare();
            this.sourceReceiver.receive((ISource)dbSlowStatBuilder.toDatabaseSlowStatement());
        });
        this.logicEndpointBuilders.forEach(logicEndpointBuilder -> {
            logicEndpointBuilder.prepare();
            this.sourceReceiver.receive((ISource)logicEndpointBuilder.toEndpoint());
        });
    }

    private void parseLogicEndpoints(SpanObject span, SegmentObject segmentObject) {
        span.getTagsList().forEach(tag -> {
            switch (tag.getKey()) {
                case "x-le": {
                    boolean status;
                    int latency;
                    String logicEndpointName;
                    JsonObject tagValue = (JsonObject)this.gson.fromJson(tag.getValue(), JsonObject.class);
                    boolean isLocalSpan = SpanType.Local.equals((Object)span.getSpanType());
                    if (isLocalSpan && tagValue.has("logic-span") && tagValue.get("logic-span").getAsBoolean()) {
                        logicEndpointName = span.getOperationName();
                        latency = (int)(span.getEndTime() - span.getStartTime());
                        status = !span.getIsError();
                    } else {
                        if (!tagValue.has("name") || !tagValue.has("latency") || !tagValue.has("status")) break;
                        logicEndpointName = tagValue.get("name").getAsString();
                        latency = tagValue.get("latency").getAsInt();
                        status = tagValue.get("status").getAsBoolean();
                    }
                    EndpointSourceBuilder sourceBuilder = new EndpointSourceBuilder(this.namingControl);
                    sourceBuilder.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)span.getStartTime()));
                    sourceBuilder.setDestServiceName(segmentObject.getService());
                    sourceBuilder.setDestServiceInstanceName(segmentObject.getServiceInstance());
                    sourceBuilder.setDestEndpointName(logicEndpointName);
                    sourceBuilder.setDestLayer(Layer.GENERAL);
                    sourceBuilder.setDetectPoint(DetectPoint.SERVER);
                    sourceBuilder.setLatency(latency);
                    sourceBuilder.setStatus(status);
                    sourceBuilder.setType(RequestType.LOGIC);
                    this.logicEndpointBuilders.add(sourceBuilder);
                }
            }
        });
    }

    protected Layer identifyRemoteServiceLayer(SpanLayer spanLayer, String peer) {
        switch (spanLayer) {
            case Unknown: {
                return Layer.UNDEFINED;
            }
            case Database: {
                return Layer.VIRTUAL_DATABASE;
            }
            case RPCFramework: {
                return Layer.GENERAL;
            }
            case Http: {
                if (this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(peer)) {
                    return Layer.VIRTUAL_GATEWAY;
                }
                return Layer.GENERAL;
            }
            case MQ: {
                return Layer.VIRTUAL_MQ;
            }
            case Cache: {
                return Layer.VIRTUAL_CACHE;
            }
            case UNRECOGNIZED: {
                return Layer.UNDEFINED;
            }
            case FAAS: {
                return Layer.FAAS;
            }
        }
        throw new UnexpectedException("Can't transfer to the Layer. SpanLayer=" + spanLayer);
    }

    @Generated
    public RPCAnalysisListener(SourceReceiver sourceReceiver, AnalyzerModuleConfig config, NetworkAddressAliasCache networkAddressAliasCache, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.config = config;
        this.networkAddressAliasCache = networkAddressAliasCache;
        this.namingControl = namingControl;
    }

    public static class Factory
    implements AnalysisListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NetworkAddressAliasCache networkAddressAliasCache;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.networkAddressAliasCache = (NetworkAddressAliasCache)moduleManager.find("core").provider().getService(NetworkAddressAliasCache.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public AnalysisListener create(ModuleManager moduleManager, AnalyzerModuleConfig config) {
            return new RPCAnalysisListener(this.sourceReceiver, config, this.networkAddressAliasCache, this.namingControl);
        }
    }
}

