/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DatabaseSlowStatement;

public class DatabaseSlowStatementBuilder {
    private final NamingControl namingControl;
    private String id;
    private String traceId;
    private String serviceName;
    private Layer layer = Layer.VIRTUAL_DATABASE;
    private String statement;
    private long latency;
    private long timeBucket;

    void prepare() {
        this.serviceName = this.namingControl.formatServiceName(this.serviceName);
    }

    DatabaseSlowStatement toDatabaseSlowStatement() {
        DatabaseSlowStatement dbSlowStat = new DatabaseSlowStatement();
        dbSlowStat.setId(this.id);
        dbSlowStat.setTraceId(this.traceId);
        dbSlowStat.setDatabaseServiceId(IDManager.ServiceID.buildId((String)this.serviceName, (boolean)false));
        dbSlowStat.setStatement(this.statement);
        dbSlowStat.setLatency(this.latency);
        dbSlowStat.setTimeBucket(this.timeBucket);
        return dbSlowStat;
    }

    @Generated
    public DatabaseSlowStatementBuilder(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public String getStatement() {
        return this.statement;
    }

    @Generated
    public void setStatement(String statement) {
        this.statement = statement;
    }

    @Generated
    public long getLatency() {
        return this.latency;
    }

    @Generated
    public void setLatency(long latency) {
        this.latency = latency;
    }

    @Generated
    public long getTimeBucket() {
        return this.timeBucket;
    }

    @Generated
    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }
}

