/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.yaml.ClassFilterConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class UninstrumentedGatewaysConfig
extends ConfigChangeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UninstrumentedGatewaysConfig.class);
    private final AtomicReference<String> settingsString;
    private volatile Map<String, GatewayInstanceInfo> gatewayInstanceKeyedByAddress = Collections.emptyMap();

    public UninstrumentedGatewaysConfig(ModuleProvider provider) {
        super("agent-analyzer", provider, "uninstrumentedGateways");
        this.settingsString = new AtomicReference<Object>(null);
        GatewayInfos defaultGateways = this.parseGatewaysFromFile("gateways.yml");
        log.info("Default configured gateways: {}", (Object)defaultGateways);
        this.onGatewaysUpdated(defaultGateways);
    }

    private void activeSetting(String config) {
        if (log.isDebugEnabled()) {
            log.debug("Updating using new static config: {}", (Object)config);
        }
        this.settingsString.set(config);
        this.onGatewaysUpdated(this.parseGatewaysFromYml(Strings.nullToEmpty((String)config)));
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting(null);
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.settingsString.get();
    }

    private void onGatewaysUpdated(GatewayInfos gateways) {
        log.info("Updating uninstrumented gateways with: {}", (Object)gateways);
        this.gatewayInstanceKeyedByAddress = Objects.isNull(gateways) ? Collections.emptyMap() : StreamSupport.stream(gateways.spliterator(), false).flatMap(instance -> instance.getInstances().stream()).collect(Collectors.toMap(GatewayInstanceInfo::getAddress, Function.identity()));
    }

    public boolean isAddressConfiguredAsGateway(String address) {
        boolean isConfiguredAsGateway;
        boolean bl = isConfiguredAsGateway = this.gatewayInstanceKeyedByAddress.get(address) != null;
        if (log.isDebugEnabled()) {
            log.debug("Address [{}] is configured as gateway: {}", (Object)address, (Object)isConfiguredAsGateway);
        }
        return isConfiguredAsGateway;
    }

    private GatewayInfos parseGatewaysFromFile(String file) {
        try {
            Reader reader = ResourceUtils.read((String)file);
            return (GatewayInfos)new Yaml((BaseConstructor)new ClassFilterConstructor(new Class[]{GatewayInfos.class, GatewayInfo.class, GatewayInstanceInfo.class})).loadAs(reader, GatewayInfos.class);
        }
        catch (FileNotFoundException e) {
            log.error("Cannot load gateways from: {}", (Object)file, (Object)e);
            return GatewayInfos.EMPTY;
        }
    }

    private GatewayInfos parseGatewaysFromYml(String ymlContent) {
        try {
            return (GatewayInfos)new Yaml((BaseConstructor)new ClassFilterConstructor(new Class[]{GatewayInfos.class, GatewayInfo.class, GatewayInstanceInfo.class})).loadAs(ymlContent, GatewayInfos.class);
        }
        catch (Exception e) {
            log.error("Failed to parse yml content as gateways: \n{}", (Object)ymlContent, (Object)e);
            return GatewayInfos.EMPTY;
        }
    }

    public static class GatewayInstanceInfo {
        private String host;
        private Integer port;

        String getAddress() {
            return this.getHost() + ":" + (Objects.isNull(this.getPort()) || this.getPort() <= 0 ? "80" : this.getPort());
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(Integer port) {
            this.port = port;
        }

        @Generated
        public String toString() {
            return "UninstrumentedGatewaysConfig.GatewayInstanceInfo(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }

    public static class GatewayInfos
    implements Iterable<GatewayInfo> {
        static final GatewayInfos EMPTY = new GatewayInfos();
        private Collection<GatewayInfo> gateways = new ArrayList<GatewayInfo>();

        GatewayInfos() {
        }

        @Override
        public Iterator<GatewayInfo> iterator() {
            return this.gateways.iterator();
        }

        @Generated
        public String toString() {
            return "UninstrumentedGatewaysConfig.GatewayInfos(gateways=" + this.getGateways() + ")";
        }

        @Generated
        public Collection<GatewayInfo> getGateways() {
            return this.gateways;
        }

        @Generated
        public void setGateways(Collection<GatewayInfo> gateways) {
            this.gateways = gateways;
        }
    }

    public static class GatewayInfo {
        private String name;
        private List<GatewayInstanceInfo> instances;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<GatewayInstanceInfo> getInstances() {
            return this.instances;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setInstances(List<GatewayInstanceInfo> instances) {
            this.instances = instances;
        }

        @Generated
        public String toString() {
            return "UninstrumentedGatewaysConfig.GatewayInfo(name=" + this.getName() + ", instances=" + this.getInstances() + ")";
        }
    }
}

