/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.meter.process;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.apm.network.language.agent.v3.Label;
import org.apache.skywalking.apm.network.language.agent.v3.MeterBucketValue;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;
import org.apache.skywalking.apm.network.language.agent.v3.MeterHistogram;
import org.apache.skywalking.apm.network.language.agent.v3.MeterSingleValue;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.dsl.HistogramType;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamilyBuilder;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.MeterProcessService;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.SampleBuilder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeterProcessor.class);
    private final MeterProcessService processService;
    private final Map<String, List<SampleBuilder>> meters = new HashMap<String, List<SampleBuilder>>();
    private String service;
    private String serviceInstance;
    private Long timestamp;

    public MeterProcessor(MeterProcessService processService) {
        this.processService = processService;
    }

    public void read(MeterData data) {
        switch (data.getMetricCase()) {
            case SINGLEVALUE: {
                MeterSingleValue single = data.getSingleValue();
                this.meters.computeIfAbsent(single.getName(), k -> new ArrayList()).add(SampleBuilder.builder().name(single.getName()).labels((ImmutableMap<String, String>)((ImmutableMap)single.getLabelsList().stream().collect(ImmutableMap.toImmutableMap(Label::getName, Label::getValue)))).value(single.getValue()).build());
                break;
            }
            case HISTOGRAM: {
                MeterHistogram histogram = data.getHistogram();
                Map<String, String> baseLabel = histogram.getLabelsList().stream().collect(Collectors.toMap(Label::getName, Label::getValue));
                this.meters.computeIfAbsent(histogram.getName(), k -> new ArrayList()).addAll(histogram.getValuesList().stream().map(v -> SampleBuilder.builder().name(histogram.getName()).labels((ImmutableMap<String, String>)ImmutableMap.builder().putAll(baseLabel).put((Object)"le", (Object)this.parseHistogramBucket((MeterBucketValue)v)).build()).value(v.getCount()).build()).collect(Collectors.toList()));
                break;
            }
            default: {
                return;
            }
        }
        if (StringUtil.isNotEmpty((String)data.getService())) {
            this.service = data.getService();
        }
        if (StringUtil.isNotEmpty((String)data.getServiceInstance())) {
            this.serviceInstance = data.getServiceInstance();
        }
        if (data.getTimestamp() > 0L) {
            this.timestamp = data.getTimestamp();
        }
    }

    public void process() {
        if (StringUtils.isEmpty((CharSequence)this.service) || StringUtil.isEmpty((String)this.serviceInstance) || this.timestamp == null) {
            return;
        }
        List<MetricConvert> converts = this.processService.converts();
        if (CollectionUtils.isEmpty(converts)) {
            return;
        }
        try {
            converts.forEach(convert -> convert.toMeter((ImmutableMap)this.meters.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> SampleFamilyBuilder.newBuilder((Sample[])((Sample[])((List)v.getValue()).stream().map(s -> s.build(this.service, this.serviceInstance, this.timestamp)).toArray(Sample[]::new))).histogramType(HistogramType.ORDINARY).defaultHistogramBucketUnit(TimeUnit.MILLISECONDS).build()))));
        }
        catch (Exception e) {
            log.warn("Process meters failure.", (Throwable)e);
        }
    }

    private String parseHistogramBucket(MeterBucketValue bucketValue) {
        if (bucketValue.getIsNegativeInfinity()) {
            return String.valueOf(Long.MIN_VALUE);
        }
        return String.valueOf(bucketValue.getBucket());
    }
}

