/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Set;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.apollo.ApolloConfigurationCenterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloConfigWatcherRegister
extends ConfigWatcherRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApolloConfigWatcherRegister.class);
    private final Config configReader;

    public ApolloConfigWatcherRegister(ApolloConfigurationCenterSettings settings) {
        super((long)settings.getPeriod());
        String namespace = settings.getNamespace();
        boolean isDefaultNamespace = Strings.isNullOrEmpty((String)namespace);
        if (isDefaultNamespace) {
            this.configReader = ConfigService.getAppConfig();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Read dynamic configs from Apollo default namespace");
            }
        } else {
            this.configReader = ConfigService.getConfig((String)namespace);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Read dynamic configs from Apollo namespace: {}", (Object)namespace);
            }
        }
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable configTable = new ConfigTable();
        for (String name : keys) {
            String value = this.configReader.getProperty(name, null);
            configTable.add(new ConfigTable.ConfigItem(name, value));
        }
        return Optional.of(configTable);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable groupConfigTable = new GroupConfigTable();
        Set allKeys = this.configReader.getPropertyNames();
        keys.forEach(key -> {
            GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
            groupConfigTable.addGroupConfigItems(groupConfigItems);
            String groupKey = key + ".";
            if (allKeys != null) {
                allKeys.stream().filter(it -> it.startsWith(groupKey)).forEach(groupItemKey -> {
                    String itemValue = this.configReader.getProperty(groupItemKey, null);
                    String itemName = groupItemKey.substring(groupKey.length());
                    groupConfigItems.add(new ConfigTable.ConfigItem(itemName, itemValue));
                });
            }
        });
        return Optional.of(groupConfigTable);
    }
}

