/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public class H2ZipkinQueryDAO
implements IZipkinQueryDAO {
    private final JDBCHikariCPClient h2Client;
    private static final int NAME_QUERY_MAX_SIZE = Integer.MAX_VALUE;
    private static final Gson GSON = new Gson();

    public H2ZipkinQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getServiceNames() throws IOException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("service_name").append(" from ").append("zipkin_service_traffic");
        sql.append(" where ").append("1=1");
        sql.append(" limit ").append(Integer.MAX_VALUE);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), new Object[0]);
            ArrayList<String> services = new ArrayList<String>();
            while (resultSet.next()) {
                services.add(resultSet.getString("service_name"));
            }
            ArrayList<String> arrayList = services;
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getRemoteServiceNames(String serviceName) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(1);
        sql.append("select ").append("remote_service_name").append(" from ").append("zipkin_service_relation_traffic");
        sql.append(" where ");
        sql.append("service_name").append(" = ?");
        sql.append(" limit ").append(Integer.MAX_VALUE);
        condition.add(serviceName);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            ArrayList<String> remoteServices = new ArrayList<String>();
            while (resultSet.next()) {
                remoteServices.add(resultSet.getString("remote_service_name"));
            }
            ArrayList<String> arrayList = remoteServices;
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSpanNames(String serviceName) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(1);
        sql.append("select ").append("span_name").append(" from ").append("zipkin_service_span_traffic");
        sql.append(" where ");
        sql.append("service_name").append(" = ?");
        sql.append(" limit ").append(Integer.MAX_VALUE);
        condition.add(serviceName);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            ArrayList<String> spanNames = new ArrayList<String>();
            while (resultSet.next()) {
                spanNames.add(resultSet.getString("span_name"));
            }
            ArrayList<String> arrayList = spanNames;
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Span> getTrace(String traceId) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(1);
        sql.append("select * from ").append("zipkin_span");
        sql.append(" where ");
        sql.append("trace_id").append(" = ?");
        condition.add(traceId);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            ArrayList<Span> trace = new ArrayList<Span>();
            while (resultSet.next()) {
                trace.add(this.buildSpan(resultSet));
            }
            ArrayList<Span> arrayList = trace;
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public List<List<Span>> getTraces(QueryRequest request) throws IOException {
        int i;
        long startTimeMillis = request.endTs() - request.lookback();
        long endTimeMillis = request.endTs();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(5);
        ArrayList annotations = new ArrayList(request.annotationQuery().entrySet());
        sql.append("select ").append("trace_id").append(", ").append("max(").append("timestamp_millis").append(")").append(" from ");
        sql.append("zipkin_span");
        if (!CollectionUtils.isEmpty(annotations)) {
            for (i = 0; i < annotations.size(); ++i) {
                sql.append(" inner join ").append("zipkin_query").append(" ");
                sql.append("zipkin_query" + i);
                sql.append(" on ").append("zipkin_span").append(".").append("id").append(" = ");
                sql.append("zipkin_query" + i).append(".").append("id");
            }
        }
        sql.append(" where ");
        sql.append(" 1=1 ");
        if (startTimeMillis > 0L && endTimeMillis > 0L) {
            sql.append(" and ");
            sql.append("timestamp_millis").append(" >= ?");
            condition.add(startTimeMillis);
            sql.append(" and ");
            sql.append("timestamp_millis").append(" <= ?");
            condition.add(endTimeMillis);
        }
        if (request.minDuration() != null) {
            sql.append(" and ");
            sql.append("duration").append(" >= ?");
            condition.add(request.minDuration());
        }
        if (request.maxDuration() != null) {
            sql.append(" and ");
            sql.append("duration").append(" <= ?");
            condition.add(request.maxDuration());
        }
        if (!StringUtil.isEmpty((String)request.serviceName())) {
            sql.append(" and ");
            sql.append("local_endpoint_service_name").append(" = ?");
            condition.add(request.serviceName());
        }
        if (!StringUtil.isEmpty((String)request.remoteServiceName())) {
            sql.append(" and ");
            sql.append("remote_endpoint_service_name").append(" = ?");
            condition.add(request.remoteServiceName());
        }
        if (!StringUtil.isEmpty((String)request.spanName())) {
            sql.append(" and ");
            sql.append("name").append(" = ?");
            condition.add(request.spanName());
        }
        if (CollectionUtils.isNotEmpty(annotations)) {
            for (i = 0; i < annotations.size(); ++i) {
                Map.Entry annotation = (Map.Entry)annotations.get(i);
                if (((String)annotation.getValue()).isEmpty()) {
                    sql.append(" and ").append("zipkin_query").append(i).append(".");
                    sql.append("query").append(" = ?");
                    condition.add(annotation.getKey());
                    continue;
                }
                sql.append(" and ").append("zipkin_query").append(i).append(".");
                sql.append("query").append(" = ?");
                condition.add((String)annotation.getKey() + "=" + (String)annotation.getValue());
            }
        }
        sql.append(" group by ").append("trace_id");
        sql.append(" order by max(").append("timestamp_millis").append(") desc");
        sql.append(" limit ").append(request.limit());
        HashSet<String> traceIds = new HashSet<String>();
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            while (resultSet.next()) {
                traceIds.add(resultSet.getString("trace_id"));
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return this.getTraces(traceIds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<Span>> getTraces(Set<String> traceIds) throws IOException {
        if (CollectionUtils.isEmpty(traceIds)) {
            return new ArrayList<List<Span>>();
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(5);
        sql.append("select * from ").append("zipkin_span");
        sql.append(" where ");
        sql.append(" 1=1 ");
        int i = 0;
        sql.append(" and ");
        for (String traceId : traceIds) {
            sql.append("trace_id").append(" = ?");
            condition.add(traceId);
            if (i != traceIds.size() - 1) {
                sql.append(" or ");
            }
            ++i;
        }
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            List<List<Span>> list = this.buildTraces(resultSet);
            return list;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private List<List<Span>> buildTraces(ResultSet resultSet) throws SQLException {
        LinkedHashMap groupedByTraceId = new LinkedHashMap();
        while (resultSet.next()) {
            Span span = this.buildSpan(resultSet);
            String traceId = span.traceId();
            groupedByTraceId.putIfAbsent(traceId, new ArrayList());
            ((List)groupedByTraceId.get(traceId)).add(span);
        }
        return new ArrayList<List<Span>>(groupedByTraceId.values());
    }

    private Span buildSpan(ResultSet resultSet) throws SQLException {
        String annotationString;
        Span.Builder span = Span.newBuilder();
        span.traceId(resultSet.getString("trace_id"));
        span.id(resultSet.getString("span_id"));
        span.parentId(resultSet.getString("parent_id"));
        span.kind(Span.Kind.valueOf((String)resultSet.getString("kind")));
        span.timestamp(resultSet.getLong("timestamp"));
        span.duration(resultSet.getLong("duration"));
        span.name(resultSet.getString("name"));
        if (resultSet.getString("debug") != null) {
            span.debug(Boolean.TRUE);
        }
        if (resultSet.getString("shared") != null) {
            span.shared(Boolean.TRUE);
        }
        Endpoint.Builder localEndpoint = Endpoint.newBuilder();
        localEndpoint.serviceName(resultSet.getString("local_endpoint_service_name"));
        if (!StringUtil.isEmpty((String)resultSet.getString("local_endpoint_ipv4"))) {
            localEndpoint.parseIp(resultSet.getString("local_endpoint_ipv4"));
        } else {
            localEndpoint.parseIp(resultSet.getString("local_endpoint_ipv6"));
        }
        localEndpoint.port(resultSet.getInt("local_endpoint_port"));
        span.localEndpoint(localEndpoint.build());
        Endpoint.Builder remoteEndpoint = Endpoint.newBuilder();
        remoteEndpoint.serviceName(resultSet.getString("remote_endpoint_service_name"));
        if (!StringUtil.isEmpty((String)resultSet.getString("remote_endpoint_ipv4"))) {
            remoteEndpoint.parseIp(resultSet.getString("remote_endpoint_ipv4"));
        } else {
            remoteEndpoint.parseIp(resultSet.getString("remote_endpoint_ipv6"));
        }
        remoteEndpoint.port(resultSet.getInt("remote_endpoint_port"));
        span.remoteEndpoint(remoteEndpoint.build());
        String tagsString = resultSet.getString("tags");
        if (!StringUtil.isEmpty((String)tagsString)) {
            JsonObject tagsJson = (JsonObject)GSON.fromJson(tagsString, JsonObject.class);
            for (Map.Entry tag : tagsJson.entrySet()) {
                span.putTag((String)tag.getKey(), ((JsonElement)tag.getValue()).getAsString());
            }
        }
        if (!StringUtil.isEmpty((String)(annotationString = resultSet.getString("annotations")))) {
            JsonObject annotationJson = (JsonObject)GSON.fromJson(annotationString, JsonObject.class);
            for (Map.Entry annotation : annotationJson.entrySet()) {
                span.addAnnotation(Long.parseLong((String)annotation.getKey()), ((JsonElement)annotation.getValue()).getAsString());
            }
        }
        return span.build();
    }
}

