/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class H2TraceQueryDAO
implements ITraceQueryDAO {
    private ModuleManager manager;
    private JDBCHikariCPClient h2Client;
    private List<String> searchableTagKeys;

    public H2TraceQueryDAO(ModuleManager manager, JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
        this.manager = manager;
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<Tag> tags) throws IOException {
        int i;
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableTracesTags().split(","));
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("segment");
        if (!CollectionUtils.isEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" inner join ").append("segment_tag").append(" ");
                sql.append("segment_tag" + i);
                sql.append(" on ").append("segment").append(".").append("id").append(" = ");
                sql.append("segment_tag" + i).append(".").append("id");
            }
        }
        sql.append(" where ");
        sql.append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("segment").append(".").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("segment").append(".").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (minDuration != 0L) {
            sql.append(" and ").append("latency").append(" >= ?");
            parameters.add(minDuration);
        }
        if (maxDuration != 0L) {
            sql.append(" and ").append("latency").append(" <= ?");
            parameters.add(maxDuration);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (!Strings.isNullOrEmpty((String)endpointId)) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            sql.append(" and ").append("trace_id").append(" = ?");
            parameters.add(traceId);
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                int foundIdx = this.searchableTagKeys.indexOf(tags.get(i).getKey());
                if (foundIdx <= -1) {
                    return new TraceBrief();
                }
                sql.append(" and ").append("segment_tag" + i).append(".");
                sql.append("tags").append(" = ?");
                parameters.add(tags.get(i).toString());
            }
        }
        switch (traceState) {
            case ERROR: {
                sql.append(" and ").append("is_error").append(" = ").append(1);
                break;
            }
            case SUCCESS: {
                sql.append(" and ").append("is_error").append(" = ").append(0);
            }
        }
        switch (queryOrder) {
            case BY_START_TIME: {
                sql.append(" order by ").append("start_time").append(" ").append("desc");
                break;
            }
            case BY_DURATION: {
                sql.append(" order by ").append("latency").append(" ").append("desc");
            }
        }
        TraceBrief traceBrief = new TraceBrief();
        try (Connection connection = this.h2Client.getConnection();){
            this.buildLimit(sql, from, limit);
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, "select segment_id, start_time, endpoint_id, latency, is_error, trace_id " + sql, parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    BasicTrace basicTrace = new BasicTrace();
                    basicTrace.setSegmentId(resultSet.getString("segment_id"));
                    basicTrace.setStart(resultSet.getString("start_time"));
                    basicTrace.getEndpointNames().add(IDManager.EndpointID.analysisId((String)resultSet.getString("endpoint_id")).getEndpointName());
                    basicTrace.setDuration(resultSet.getInt("latency"));
                    basicTrace.setError(BooleanUtils.valueToBoolean((int)resultSet.getInt("is_error")));
                    String traceIds = resultSet.getString("trace_id");
                    basicTrace.getTraceIds().add(traceIds);
                    traceBrief.getTraces().add(basicTrace);
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return traceBrief;
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select segment_id, trace_id, service_id, service_instance_id, start_time, latency, is_error, data_binary from segment where trace_id = ?", new Object[]{traceId});){
            while (resultSet.next()) {
                SegmentRecord segmentRecord = new SegmentRecord();
                segmentRecord.setSegmentId(resultSet.getString("segment_id"));
                segmentRecord.setTraceId(resultSet.getString("trace_id"));
                segmentRecord.setServiceId(resultSet.getString("service_id"));
                segmentRecord.setServiceInstanceId(resultSet.getString("service_instance_id"));
                segmentRecord.setStartTime(resultSet.getLong("start_time"));
                segmentRecord.setLatency(resultSet.getInt("latency"));
                segmentRecord.setIsError(resultSet.getInt("is_error"));
                String dataBinaryBase64 = resultSet.getString("data_binary");
                if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                    segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
                }
                segmentRecords.add(segmentRecord);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return segmentRecords;
    }

    public List<Span> doFlexibleTraceQuery(String traceId) {
        return Collections.emptyList();
    }
}

