/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2TopologyQueryDAO
implements ITopologyQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2TopologyQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(long startTB, long endTB, List<String> serviceIds) throws IOException {
        return this.loadServiceCalls("service_relation_server_side", startTB, endTB, "source_service_id", "dest_service_id", serviceIds, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(long startTB, long endTB, List<String> serviceIds) throws IOException {
        return this.loadServiceCalls("service_relation_client_side", startTB, endTB, "source_service_id", "dest_service_id", serviceIds, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(long startTB, long endTB) throws IOException {
        return this.loadServiceCalls("service_relation_server_side", startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<String>(0), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(long startTB, long endTB) throws IOException {
        return this.loadServiceCalls("service_relation_client_side", startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<String>(0), DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String clientServiceId, String serverServiceId, long startTB, long endTB) throws IOException {
        return this.loadServiceInstanceCalls("service_instance_relation_server_side", startTB, endTB, "source_service_id", "dest_service_id", clientServiceId, serverServiceId, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String clientServiceId, String serverServiceId, long startTB, long endTB) throws IOException {
        return this.loadServiceInstanceCalls("service_instance_relation_client_side", startTB, endTB, "source_service_id", "dest_service_id", clientServiceId, serverServiceId, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadEndpointRelation(long startTB, long endTB, String destEndpointId) throws IOException {
        List<Call.CallDetail> calls = this.loadEndpointFromSide("endpoint_relation_server_side", startTB, endTB, "source_endpoint", "dest_endpoint", destEndpointId, false);
        calls.addAll(this.loadEndpointFromSide("endpoint_relation_server_side", startTB, endTB, "source_endpoint", "dest_endpoint", destEndpointId, true));
        return calls;
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtClientSide(String serviceInstanceId, long startTB, long endTB) throws IOException {
        return this.loadProcessFromSide(startTB, endTB, serviceInstanceId, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadProcessRelationDetectedAtServerSide(String serviceInstanceId, long startTB, long endTB) throws IOException {
        return this.loadProcessFromSide(startTB, endTB, serviceInstanceId, DetectPoint.SERVER);
    }

    private List<Call.CallDetail> loadServiceCalls(String tableName, long startTB, long endTB, String sourceCName, String destCName, List<String> serviceIds, DetectPoint detectPoint) throws IOException {
        Object[] conditions = new Object[serviceIds.size() * 2 + 2];
        conditions[0] = startTB;
        conditions[1] = endTB;
        StringBuilder serviceIdMatchSql = new StringBuilder();
        if (serviceIds.size() > 0) {
            serviceIdMatchSql.append("and (");
            for (int i = 0; i < serviceIds.size(); ++i) {
                serviceIdMatchSql.append(sourceCName + "=? or " + destCName + "=? ");
                conditions[i * 2 + 2] = serviceIds.get(i);
                conditions[i * 2 + 1 + 2] = serviceIds.get(i);
                if (i == serviceIds.size() - 1) continue;
                serviceIdMatchSql.append("or ");
            }
            serviceIdMatchSql.append(")");
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id, component_id from " + tableName + " where " + "time_bucket" + ">= ? and " + "time_bucket" + "<=? " + serviceIdMatchSql.toString() + " group by " + "entity_id" + "," + "component_id", conditions);){
            this.buildServiceCalls(resultSet, calls, detectPoint);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return calls;
    }

    private List<Call.CallDetail> loadServiceInstanceCalls(String tableName, long startTB, long endTB, String sourceCName, String descCName, String sourceServiceId, String destServiceId, DetectPoint detectPoint) throws IOException {
        Object[] conditions = new Object[]{startTB, endTB, sourceServiceId, destServiceId, destServiceId, sourceServiceId};
        StringBuilder serviceIdMatchSql = new StringBuilder("and ((").append(sourceCName).append("=? and ").append(descCName).append("=?").append(") or (").append(sourceCName).append("=? and ").append(descCName).append("=?").append("))");
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id, component_id from " + tableName + " where " + "time_bucket" + ">= ? and " + "time_bucket" + "<=? " + serviceIdMatchSql.toString() + " group by " + "entity_id" + ", " + "component_id", conditions);){
            this.buildInstanceCalls(resultSet, calls, detectPoint);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return calls;
    }

    private List<Call.CallDetail> loadEndpointFromSide(String tableName, long startTB, long endTB, String sourceCName, String destCName, String id, boolean isSourceId) throws IOException {
        Object[] conditions = new Object[]{startTB, endTB, id};
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id from " + tableName + " where " + "time_bucket" + ">= ? and " + "time_bucket" + "<=? and " + (isSourceId ? sourceCName : destCName) + "=? group by " + "entity_id", conditions);){
            this.buildEndpointCalls(resultSet, calls, DetectPoint.SERVER);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return calls;
    }

    private List<Call.CallDetail> loadProcessFromSide(long startTB, long endTB, String instanceId, DetectPoint detectPoint) throws IOException {
        Object[] conditions = new Object[]{startTB, endTB, instanceId};
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id, component_id from " + (detectPoint == DetectPoint.SERVER ? "process_relation_server_side" : "process_relation_client_side") + " where " + "time_bucket" + ">= ? and " + "time_bucket" + "<=? and " + "service_instance_id" + "=? group by " + "entity_id" + ", " + "component_id", conditions);){
            this.buildProcessCalls(resultSet, calls, detectPoint);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return calls;
    }

    private void buildServiceCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            int componentId = resultSet.getInt("component_id");
            call.buildFromServiceRelation(entityId, componentId, detectPoint);
            calls.add(call);
        }
    }

    private void buildInstanceCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            int componentId = resultSet.getInt("component_id");
            call.buildFromInstanceRelation(entityId, componentId, detectPoint);
            calls.add(call);
        }
    }

    private void buildEndpointCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            call.buildFromEndpointRelation(entityId, detectPoint);
            calls.add(call);
        }
    }

    private void buildProcessCalls(ResultSet resultSet, List<Call.CallDetail> calls, DetectPoint detectPoint) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            int componentId = resultSet.getInt("component_id");
            call.buildProcessRelation(entityId, componentId, detectPoint);
            calls.add(call);
        }
    }
}

