/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2TagAutoCompleteQueryDAO
implements ITagAutoCompleteQueryDAO {
    private final JDBCHikariCPClient h2Client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> queryTagAutocompleteKeys(TagType tagType, int limit, long startSecondTB, long endSecondTB) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(2);
        sql.append("select distinct ").append("tag_key").append(" from ").append("tag_autocomplete").append(" where ");
        sql.append(" 1=1 ");
        this.appendTagAutocompleteCondition(tagType, startSecondTB, endSecondTB, sql, condition);
        sql.append(" limit ").append(limit);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            HashSet<String> tagKeys = new HashSet<String>();
            while (resultSet.next()) {
                tagKeys.add(resultSet.getString("tag_key"));
            }
            HashSet<String> hashSet = tagKeys;
            return hashSet;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> queryTagAutocompleteValues(TagType tagType, String tagKey, int limit, long startSecondTB, long endSecondTB) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(3);
        sql.append("select * from ").append("tag_autocomplete").append(" where ");
        sql.append("tag_key").append(" = ?");
        condition.add(tagKey);
        this.appendTagAutocompleteCondition(tagType, startSecondTB, endSecondTB, sql, condition);
        sql.append(" limit ").append(limit);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            HashSet<String> tagValues = new HashSet<String>();
            while (resultSet.next()) {
                tagValues.add(resultSet.getString("tag_value"));
            }
            HashSet<String> hashSet = tagValues;
            return hashSet;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private void appendTagAutocompleteCondition(TagType tagType, long startSecondTB, long endSecondTB, StringBuilder sql, List<Object> condition) {
        sql.append(" and ");
        sql.append("tag_type").append(" = ?");
        condition.add(tagType.name());
        long startTB = startSecondTB / 1000000L * 10000L;
        long endTB = endSecondTB / 1000000L * 10000L + 9999L;
        if (startTB > 0L) {
            sql.append(" and ");
            sql.append("time_bucket").append(">=?");
            condition.add(startTB);
        }
        if (endTB > 0L) {
            sql.append(" and ");
            sql.append("time_bucket").append("<=?");
            condition.add(endTB);
        }
    }

    @Generated
    public H2TagAutoCompleteQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }
}

