/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NoneStreamDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RecordDAO;

public class H2StorageDAO
implements StorageDAO {
    private final JDBCHikariCPClient h2Client;

    public IMetricsDAO newMetricsDao(StorageBuilder storageBuilder) {
        return new H2MetricsDAO(this.h2Client, (StorageBuilder<Metrics>)storageBuilder);
    }

    public IRecordDAO newRecordDao(StorageBuilder storageBuilder) {
        return new H2RecordDAO(this.h2Client, (StorageBuilder<Record>)storageBuilder);
    }

    public INoneStreamDAO newNoneStreamDao(StorageBuilder storageBuilder) {
        return new H2NoneStreamDAO(this.h2Client, (StorageBuilder<NoneStream>)storageBuilder);
    }

    public IManagementDAO newManagementDao(StorageBuilder storageBuilder) {
        return new H2ManagementDAO(this.h2Client, (StorageBuilder<ManagementData>)storageBuilder);
    }

    @Generated
    public H2StorageDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }
}

