/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2NetworkAddressAliasDAO
extends H2SQLExecutor
implements INetworkAddressAliasDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2NetworkAddressAliasDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2NetworkAddressAliasDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<NetworkAddressAlias> loadLastUpdate(long lastUpdateTime) {
        ArrayList<NetworkAddressAlias> networkAddressAliases = new ArrayList<NetworkAddressAlias>();
        try {
            StringBuilder sql = new StringBuilder("select * from ");
            sql.append("network_address_alias");
            sql.append(" where ").append("last_update_time_bucket").append(">?");
            try (Connection connection = this.h2Client.getConnection();
                 ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), new Object[]{lastUpdateTime});){
                NetworkAddressAlias networkAddressAlias;
                do {
                    if ((networkAddressAlias = (NetworkAddressAlias)this.toStorageData(resultSet, "network_address_alias", (StorageBuilder<? extends StorageData>)new NetworkAddressAlias.Builder())) == null) continue;
                    networkAddressAliases.add(networkAddressAlias);
                } while (networkAddressAlias != null);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
        }
        return networkAddressAliases;
    }
}

