/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2MetricsDAO
extends H2SQLExecutor
implements IMetricsDAO {
    private JDBCHikariCPClient h2Client;
    private StorageBuilder<Metrics> storageBuilder;

    public H2MetricsDAO(JDBCHikariCPClient h2Client, StorageBuilder<Metrics> storageBuilder) {
        this.h2Client = h2Client;
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<Metrics> metrics) throws IOException {
        String[] ids = metrics.stream().map(Metrics::id).collect(Collectors.toList()).toArray(new String[0]);
        List<StorageData> storageDataList = this.getByIDs(this.h2Client, model.getName(), ids, this.storageBuilder);
        ArrayList<Metrics> result = new ArrayList<Metrics>(storageDataList.size());
        for (StorageData storageData : storageDataList) {
            result.add((Metrics)storageData);
        }
        return result;
    }

    public SQLExecutor prepareBatchInsert(Model model, Metrics metrics) throws IOException {
        return this.getInsertExecutor(model.getName(), metrics, this.storageBuilder, (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage());
    }

    public SQLExecutor prepareBatchUpdate(Model model, Metrics metrics) throws IOException {
        return this.getUpdateExecutor(model.getName(), metrics, this.storageBuilder);
    }
}

