/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.query.enumeration.Language;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class H2MetadataQueryDAO
implements IMetadataQueryDAO {
    private static final Gson GSON = new Gson();
    private JDBCHikariCPClient h2Client;
    private int metadataQueryMaxSize;

    public H2MetadataQueryDAO(JDBCHikariCPClient h2Client, int metadataQueryMaxSize) {
        this.h2Client = h2Client;
        this.metadataQueryMaxSize = metadataQueryMaxSize;
    }

    /*
     * Exception decompiling
     */
    public List<Service> listServices(String layer, String group) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Service> getServices(String serviceId) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(5);
        sql.append("select * from ").append("service_traffic").append(" where ");
        sql.append("service_id").append(" = ?");
        condition.add(serviceId);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            List<Service> list = this.buildServices(resultSet);
            return list;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ServiceInstance> listInstances(long startTimestamp, long endTimestamp, String serviceId) throws IOException {
        long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)startTimestamp);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(5);
        sql.append("select * from ").append("instance_traffic").append(" where ");
        sql.append("last_ping").append(" >= ?");
        condition.add(minuteTimeBucket);
        sql.append(" and ").append("service_id").append("=?");
        condition.add(serviceId);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            List<ServiceInstance> list = this.buildInstances(resultSet);
            return list;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceInstance getInstance(String instanceId) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(5);
        sql.append("select * from ").append("instance_traffic").append(" where ");
        sql.append("id").append(" = ?");
        condition.add(instanceId);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            List<ServiceInstance> instances = this.buildInstances(resultSet);
            ServiceInstance serviceInstance = instances.size() > 0 ? instances.get(0) : null;
            return serviceInstance;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public List<Endpoint> findEndpoint(String keyword, String serviceId, int limit) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(5);
        sql.append("select * from ").append("endpoint_traffic").append(" where ");
        sql.append("service_id").append("=?");
        condition.add(serviceId);
        if (!Strings.isNullOrEmpty((String)keyword)) {
            sql.append(" and ").append("name").append(" like concat('%',?,'%') ");
            condition.add(keyword);
        }
        sql.append(" limit ").append(limit);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            while (resultSet.next()) {
                Endpoint endpoint = new Endpoint();
                endpoint.setId(resultSet.getString("id"));
                endpoint.setName(resultSet.getString("name"));
                endpoints.add(endpoint);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return endpoints;
    }

    /*
     * Exception decompiling
     */
    public List<Process> listProcesses(String serviceId, ProfilingSupportStatus supportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Process> listProcesses(String serviceInstanceId, long lastPingStartTimeBucket, long lastPingEndTimeBucket, boolean includeVirtual) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Process> listProcesses(String agentId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getProcessCount(String serviceId, ProfilingSupportStatus profilingSupportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getProcessCount(String instanceId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Service> buildServices(ResultSet resultSet) throws SQLException {
        ArrayList<Service> services = new ArrayList<Service>();
        while (resultSet.next()) {
            String serviceName = resultSet.getString("name");
            Service service = new Service();
            service.setId(resultSet.getString("service_id"));
            service.setName(serviceName);
            service.setShortName(resultSet.getString("short_name"));
            service.setGroup(resultSet.getString("service_group"));
            service.getLayers().add(Layer.valueOf((int)resultSet.getInt("layer")).name());
            services.add(service);
        }
        return services;
    }

    private List<ServiceInstance> buildInstances(ResultSet resultSet) throws SQLException {
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        while (resultSet.next()) {
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setId(resultSet.getString("id"));
            serviceInstance.setName(resultSet.getString("name"));
            serviceInstance.setInstanceUUID(serviceInstance.getId());
            String propertiesString = resultSet.getString("properties");
            if (!Strings.isNullOrEmpty((String)propertiesString)) {
                JsonObject properties = (JsonObject)GSON.fromJson(propertiesString, JsonObject.class);
                for (Map.Entry property : properties.entrySet()) {
                    String key = (String)property.getKey();
                    String value = ((JsonElement)property.getValue()).getAsString();
                    if (key.equals("language")) {
                        serviceInstance.setLanguage(Language.value((String)value));
                        continue;
                    }
                    serviceInstance.getAttributes().add(new Attribute(key, value));
                }
            } else {
                serviceInstance.setLanguage(Language.UNKNOWN);
            }
            serviceInstances.add(serviceInstance);
        }
        return serviceInstances;
    }

    private void appendProcessWhereQuery(StringBuilder sql, List<Object> condition, String serviceId, String instanceId, String agentId, ProfilingSupportStatus profilingSupportStatus, long lastPingStartTimeBucket, long lastPingEndTimeBucket, boolean includeVirtual) {
        if (StringUtil.isNotEmpty((String)serviceId) || StringUtil.isNotEmpty((String)instanceId) || StringUtil.isNotEmpty((String)agentId)) {
            sql.append(" where ");
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append("service_id").append("=?");
            condition.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)instanceId)) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("instance_id").append("=?");
            condition.add(instanceId);
        }
        if (StringUtil.isNotEmpty((String)agentId)) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("agent_id").append("=?");
            condition.add(agentId);
        }
        if (profilingSupportStatus != null) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("profiling_support_status").append("=?");
            condition.add(profilingSupportStatus.value());
        }
        if (lastPingStartTimeBucket > 0L) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("last_ping").append(">=?");
            condition.add(lastPingStartTimeBucket);
        }
        if (!includeVirtual) {
            if (!condition.isEmpty()) {
                sql.append(" and ");
            }
            sql.append("detect_type").append("!=?");
            condition.add(ProcessDetectType.VIRTUAL.value());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Process getProcess(String processId) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> condition = new ArrayList<String>(5);
        sql.append("select * from ").append("process_traffic").append(" where ");
        sql.append("id").append(" = ?");
        condition.add(processId);
        sql.append(" limit ").append(this.metadataQueryMaxSize);
        try (Connection connection = this.h2Client.getConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));
            List<Process> processes = this.buildProcesses(resultSet);
            Process process = processes.size() > 0 ? processes.get(0) : null;
            return process;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private List<Process> buildProcesses(ResultSet resultSet) throws SQLException {
        ArrayList<Process> processes = new ArrayList<Process>();
        while (resultSet.next()) {
            String labelJsonString;
            Process process = new Process();
            process.setId(resultSet.getString("id"));
            process.setName(resultSet.getString("name"));
            String serviceId = resultSet.getString("service_id");
            process.setServiceId(serviceId);
            IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId((String)serviceId);
            process.setServiceName(serviceIDDefinition.getName());
            String instanceId = resultSet.getString("instance_id");
            process.setInstanceId(instanceId);
            IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId((String)instanceId);
            process.setInstanceName(instanceIDDefinition.getName());
            process.setAgentId(resultSet.getString("agent_id"));
            process.setDetectType(ProcessDetectType.valueOf((int)resultSet.getInt("detect_type")).name());
            process.setProfilingSupportStatus(ProfilingSupportStatus.valueOf((int)resultSet.getInt("profiling_support_status")).name());
            String propertiesString = resultSet.getString("properties");
            if (!Strings.isNullOrEmpty((String)propertiesString)) {
                JsonObject properties = (JsonObject)GSON.fromJson(propertiesString, JsonObject.class);
                for (Map.Entry property : properties.entrySet()) {
                    String key = (String)property.getKey();
                    String value = ((JsonElement)property.getValue()).getAsString();
                    process.getAttributes().add(new Attribute(key, value));
                }
            }
            if (!Strings.isNullOrEmpty((String)(labelJsonString = resultSet.getString("labels_json")))) {
                List labels = (List)GSON.fromJson(labelJsonString, ArrayList.class);
                process.getLabels().addAll(labels);
            }
            processes.add(process);
        }
        return processes;
    }
}

