/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2ManagementDAO
extends H2SQLExecutor
implements IManagementDAO {
    private JDBCHikariCPClient h2Client;
    private StorageBuilder<ManagementData> storageBuilder;

    public H2ManagementDAO(JDBCHikariCPClient h2Client, StorageBuilder<ManagementData> storageBuilder) {
        this.h2Client = h2Client;
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, ManagementData storageData) throws IOException {
        try (Connection connection = this.h2Client.getConnection();){
            StorageData data = this.getByID(this.h2Client, model.getName(), storageData.id(), this.storageBuilder);
            if (data != null) {
                return;
            }
            SQLExecutor insertExecutor = this.getInsertExecutor(model.getName(), storageData, this.storageBuilder, (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage());
            insertExecutor.invoke(connection);
        }
        catch (IOException | SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

