/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class H2LogQueryDAO
implements ILogQueryDAO {
    private final JDBCHikariCPClient h2Client;
    private final ModuleManager manager;
    private List<String> searchableTagKeys;

    public H2LogQueryDAO(JDBCHikariCPClient h2Client, ModuleManager manager) {
        this.h2Client = h2Client;
        this.manager = manager;
    }

    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, long startSecondTB, long endSecondTB, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        int i;
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableLogsTags().split(","));
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("log");
        if (!CollectionUtils.isEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" inner join ").append("log_tag").append(" ");
                sql.append("log_tag" + i);
                sql.append(" on ").append("log").append(".").append("id").append(" = ");
                sql.append("log_tag" + i).append(".").append("id");
            }
        }
        sql.append(" where ");
        sql.append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("log").append(".").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("log").append(".").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (Objects.nonNull(relatedTrace)) {
            if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                sql.append(" and ").append("trace_id").append(" = ?");
                parameters.add(relatedTrace.getTraceId());
            }
            if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                sql.append(" and ").append("trace_segment_id").append(" = ?");
                parameters.add(relatedTrace.getSegmentId());
            }
            if (Objects.nonNull(relatedTrace.getSpanId())) {
                sql.append(" and ").append("span_id").append(" = ?");
                parameters.add(relatedTrace.getSpanId());
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                int foundIdx = this.searchableTagKeys.indexOf(tags.get(i).getKey());
                if (foundIdx <= -1) {
                    return new Logs();
                }
                sql.append(" and ").append("log_tag" + i).append(".");
                sql.append("tags").append(" = ?");
                parameters.add(tags.get(i).toString());
            }
        }
        sql.append(" order by ").append("timestamp").append(" ").append(Order.DES.equals((Object)queryOrder) ? "desc" : "asc");
        Logs logs = new Logs();
        try (Connection connection = this.h2Client.getConnection();){
            this.buildLimit(sql, from, limit);
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    Log log = new Log();
                    log.setServiceId(resultSet.getString("service_id"));
                    log.setServiceInstanceId(resultSet.getString("service_instance_id"));
                    log.setEndpointId(resultSet.getString("endpoint_id"));
                    if (log.getEndpointId() != null) {
                        log.setEndpointName(IDManager.EndpointID.analysisId((String)log.getEndpointId()).getEndpointName());
                    }
                    log.setTraceId(resultSet.getString("trace_id"));
                    log.setTimestamp(Long.valueOf(resultSet.getLong("timestamp")));
                    log.setContentType(ContentType.instanceOf((int)resultSet.getInt("content_type")));
                    log.setContent(resultSet.getString("content"));
                    String dataBinaryBase64 = resultSet.getString("tags_raw_data");
                    if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                        this.parserDataBinary(dataBinaryBase64, log.getTags());
                    }
                    logs.getLogs().add(log);
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return logs;
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }
}

