/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2EventQueryDAO
implements IEventQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2EventQueryDAO.class);
    private final JDBCHikariCPClient client;

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        Tuple2<Stream<String>, Stream<Object>> conditionsParametersPair = this.buildQuery(condition);
        Stream conditions = (Stream)conditionsParametersPair._1();
        Object[] parameters = ((Stream)conditionsParametersPair._2()).toArray();
        String whereClause = conditions.collect(Collectors.joining(" and ", " where ", ""));
        Events result = new Events();
        try (Connection connection = this.client.getConnection();){
            Order queryOrder = Objects.isNull(condition.getOrder()) ? Order.DES : condition.getOrder();
            PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
            String sql = "select * from events" + whereClause;
            sql = Order.DES.equals((Object)queryOrder) ? sql + " order by start_time desc" : sql + " order by start_time asc";
            sql = sql + " limit " + page.getLimit() + " offset " + page.getFrom();
            if (log.isDebugEnabled()) {
                log.debug("Query SQL: {}, parameters: {}", (Object)sql, (Object)parameters);
            }
            try (ResultSet resultSet = this.client.executeQuery(connection, sql, parameters);){
                while (resultSet.next()) {
                    result.getEvents().add(this.parseResultSet(resultSet));
                }
            }
        }
        return result;
    }

    public Events queryEvents(List<EventQueryCondition> conditions) throws Exception {
        List conditionsParametersPair = conditions.stream().map(this::buildQuery).collect(Collectors.toList());
        Object[] parameters = conditionsParametersPair.stream().map(Tuple2::_2).reduce(Stream.empty(), Stream::concat).toArray();
        String whereClause = conditionsParametersPair.stream().map(Tuple2::_1).map(it -> it.collect(Collectors.joining(" and "))).collect(Collectors.joining(" or ", " where ", ""));
        Events result = new Events();
        try (Connection connection = this.client.getConnection();){
            EventQueryCondition condition = conditions.get(0);
            Order queryOrder = Objects.isNull(condition.getOrder()) ? Order.DES : condition.getOrder();
            PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
            String sql = "select * from events" + whereClause;
            sql = Order.DES.equals((Object)queryOrder) ? sql + " order by start_time desc" : sql + " order by start_time asc";
            sql = sql + " limit " + page.getLimit() + " offset " + page.getFrom();
            if (log.isDebugEnabled()) {
                log.debug("Query SQL: {}, parameters: {}", (Object)sql, (Object)parameters);
            }
            try (ResultSet resultSet = this.client.executeQuery(connection, sql, parameters);){
                while (resultSet.next()) {
                    result.getEvents().add(this.parseResultSet(resultSet));
                }
            }
        }
        return result;
    }

    protected Event parseResultSet(ResultSet resultSet) throws SQLException {
        Event event = new Event();
        event.setUuid(resultSet.getString("uuid"));
        String service = resultSet.getString("service");
        String serviceInstance = resultSet.getString("service_instance");
        String endpoint = resultSet.getString("endpoint");
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName(resultSet.getString("name"));
        event.setType(EventType.parse((String)resultSet.getString("type")));
        event.setMessage(resultSet.getString("message"));
        event.setParameters(resultSet.getString("parameters"));
        event.setStartTime(resultSet.getLong("start_time"));
        event.setEndTime(resultSet.getLong("end_time"));
        event.setLayer(Layer.valueOf((int)resultSet.getInt("layer")).name());
        return event;
    }

    protected Tuple2<Stream<String>, Stream<Object>> buildQuery(EventQueryCondition condition) {
        Duration time;
        Source source;
        Stream.Builder<String> conditions = Stream.builder();
        Stream.Builder<Object> parameters = Stream.builder();
        if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
            conditions.add("uuid=?");
            parameters.add(condition.getUuid());
        }
        if ((source = condition.getSource()) != null) {
            if (!Strings.isNullOrEmpty((String)source.getService())) {
                conditions.add("service=?");
                parameters.add(source.getService());
            }
            if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                conditions.add("service_instance=?");
                parameters.add(source.getServiceInstance());
            }
            if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                conditions.add("endpoint=?");
                parameters.add(source.getEndpoint());
            }
        }
        if (!Strings.isNullOrEmpty((String)condition.getName())) {
            conditions.add("name=?");
            parameters.add(condition.getName());
        }
        if (condition.getType() != null) {
            conditions.add("type=?");
            parameters.add(condition.getType().name());
        }
        if ((time = condition.getTime()) != null) {
            if (time.getStartTimestamp() > 0L) {
                conditions.add("start_time>?");
                parameters.add(time.getStartTimestamp());
            }
            if (time.getEndTimestamp() > 0L) {
                conditions.add("end_time<?");
                parameters.add(time.getEndTimestamp());
            }
        }
        if (!Strings.isNullOrEmpty((String)condition.getLayer())) {
            conditions.add("layer=?");
            parameters.add(String.valueOf(Layer.nameOf((String)condition.getLayer()).value()));
        }
        return Tuple.of(conditions.build(), parameters.build());
    }

    @Generated
    public H2EventQueryDAO(JDBCHikariCPClient client) {
        this.client = client;
    }
}

