/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.BatchSQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2BatchDAO
implements IBatchDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2BatchDAO.class);
    private JDBCHikariCPClient h2Client;
    private final DataCarrier<PrepareRequest> dataCarrier;
    private final int maxBatchSqlSize;

    public H2BatchDAO(JDBCHikariCPClient h2Client, int maxBatchSqlSize, int asyncBatchPersistentPoolSize) {
        this.h2Client = h2Client;
        String name = "H2_ASYNCHRONOUS_BATCH_PERSISTENT";
        if (log.isDebugEnabled()) {
            log.debug("H2_ASYNCHRONOUS_BATCH_PERSISTENT poolSize: {}, maxBatchSqlSize:{}", (Object)asyncBatchPersistentPoolSize, (Object)maxBatchSqlSize);
        }
        this.maxBatchSqlSize = maxBatchSqlSize;
        this.dataCarrier = new DataCarrier(name, asyncBatchPersistentPoolSize, 10000);
        this.dataCarrier.consume((IConsumer)new H2BatchConsumer(this), asyncBatchPersistentPoolSize, 20L);
    }

    public CompletableFuture<Void> flush(List<PrepareRequest> prepareRequests) {
        if (CollectionUtils.isEmpty(prepareRequests)) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList sqls = new ArrayList();
        prepareRequests.forEach(prepareRequest -> {
            sqls.add(prepareRequest);
            SQLExecutor sqlExecutor = (SQLExecutor)prepareRequest;
            if (!CollectionUtils.isEmpty(sqlExecutor.getAdditionalSQLs())) {
                sqls.addAll(sqlExecutor.getAdditionalSQLs());
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("to execute sql statements execute, data size: {}, maxBatchSqlSize: {}", (Object)sqls.size(), (Object)this.maxBatchSqlSize);
        }
        Map batchRequestMap = sqls.stream().collect(Collectors.groupingBy(Function.identity()));
        try (Connection connection = this.h2Client.getConnection();){
            batchRequestMap.forEach((key, requests) -> {
                try {
                    BatchSQLExecutor batchSQLExecutor = new BatchSQLExecutor((List<PrepareRequest>)requests);
                    batchSQLExecutor.invoke(connection, this.maxBatchSqlSize);
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (SQLException | JDBCClientException e) {
            log.warn("execute sql failed, discard data size: {}", (Object)prepareRequests.size(), (Object)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("execute sql statements done, data size: {}, maxBatchSqlSize: {}", (Object)prepareRequests.size(), (Object)this.maxBatchSqlSize);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void insert(InsertRequest insertRequest) {
        this.dataCarrier.produce((Object)insertRequest);
    }

    private class H2BatchConsumer
    implements IConsumer<PrepareRequest> {
        private final H2BatchDAO h2BatchDAO;

        private H2BatchConsumer(H2BatchDAO h2BatchDAO2) {
            this.h2BatchDAO = h2BatchDAO2;
        }

        public void init(Properties properties) {
        }

        public void consume(List<PrepareRequest> prepareRequests) {
            this.h2BatchDAO.flush(prepareRequests);
        }

        public void onError(List<PrepareRequest> prepareRequests, Throwable t) {
            log.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

