/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class H2AlarmQueryDAO
implements IAlarmQueryDAO {
    private JDBCHikariCPClient client;
    private final ModuleManager manager;
    private List<String> searchableTagKeys;

    public H2AlarmQueryDAO(JDBCHikariCPClient client, ModuleManager manager) {
        this.client = client;
        this.manager = manager;
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB, List<Tag> tags) throws IOException {
        int i;
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableAlarmTags().split(","));
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("alarm_record");
        if (!CollectionUtils.isEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                sql.append(" inner join ").append("alarm_record_tag").append(" ");
                sql.append("alarm_record_tag" + i);
                sql.append(" on ").append("alarm_record").append(".").append("id").append(" = ");
                sql.append("alarm_record_tag" + i).append(".").append("id");
            }
        }
        sql.append(" where ");
        sql.append(" 1=1 ");
        if (Objects.nonNull(scopeId)) {
            sql.append(" and ").append("scope").append(" = ?");
            parameters.add(scopeId);
        }
        if (startTB != 0L && endTB != 0L) {
            sql.append(" and ").append("alarm_record").append(".").append("time_bucket").append(" >= ?");
            parameters.add(startTB);
            sql.append(" and ").append("alarm_record").append(".").append("time_bucket").append(" <= ?");
            parameters.add(endTB);
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            sql.append(" and ").append("alarm_message").append(" like concat('%',?,'%') ");
            parameters.add(keyword);
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (i = 0; i < tags.size(); ++i) {
                int foundIdx = this.searchableTagKeys.indexOf(tags.get(i).getKey());
                if (foundIdx <= -1) {
                    return new Alarms();
                }
                sql.append(" and ").append("alarm_record_tag" + i).append(".");
                sql.append("tags").append(" = ?");
                parameters.add(tags.get(i).toString());
            }
        }
        sql.append(" order by ").append("start_time").append(" desc ");
        Alarms alarms = new Alarms();
        try (Connection connection = this.client.getConnection();){
            this.buildLimit(sql, from, limit);
            try (ResultSet resultSet = this.client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    AlarmMessage message = new AlarmMessage();
                    message.setId(resultSet.getString("id0"));
                    message.setId1(resultSet.getString("id1"));
                    message.setMessage(resultSet.getString("alarm_message"));
                    message.setStartTime(Long.valueOf(resultSet.getLong("start_time")));
                    message.setScope(Scope.Finder.valueOf((int)resultSet.getInt("scope")));
                    message.setScopeId(resultSet.getInt("scope"));
                    String dataBinaryBase64 = resultSet.getString("tags_raw_data");
                    if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                        this.parserDataBinaryBase64(dataBinaryBase64, message.getTags());
                    }
                    alarms.getMsgs().add(message);
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return alarms;
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }
}

