/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSQLExecutor
implements InsertRequest,
UpdateRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchSQLExecutor.class);
    private final List<PrepareRequest> prepareRequests;

    public void invoke(Connection connection, int maxBatchSqlSize) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("execute sql batch. sql by key size: {}", (Object)this.prepareRequests.size());
        }
        if (this.prepareRequests.size() == 0) {
            return;
        }
        String sql = this.prepareRequests.get(0).toString();
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int pendingCount = 0;
            for (int k = 0; k < this.prepareRequests.size(); ++k) {
                SQLExecutor sqlExecutor = (SQLExecutor)this.prepareRequests.get(k);
                sqlExecutor.setParameters(preparedStatement);
                preparedStatement.addBatch();
                if (k > 0 && k % maxBatchSqlSize == 0) {
                    this.executeBatch(preparedStatement, maxBatchSqlSize, sql);
                    pendingCount = 0;
                    continue;
                }
                ++pendingCount;
            }
            if (pendingCount > 0) {
                this.executeBatch(preparedStatement, pendingCount, sql);
            }
        }
    }

    private void executeBatch(PreparedStatement preparedStatement, int pendingCount, String sql) throws SQLException {
        long start = System.currentTimeMillis();
        preparedStatement.executeBatch();
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            long cost = end - start;
            log.debug("execute batch sql, batch size: {}, cost:{}ms, sql: {}", new Object[]{pendingCount, cost, sql});
        }
    }

    @Generated
    public BatchSQLExecutor(List<PrepareRequest> prepareRequests) {
        this.prepareRequests = prepareRequests;
    }
}

