/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.configmap;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationSettings;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationWatcherRegister;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigurationConfigmapInformer;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;

public class ConfigmapConfigurationProvider
extends AbstractConfigurationProvider {
    private final ConfigmapConfigurationSettings settings = new ConfigmapConfigurationSettings();

    public String name() {
        return "k8s-configmap";
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.settings;
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        if (Strings.isNullOrEmpty((String)this.settings.getLabelSelector()) || Strings.isNullOrEmpty((String)this.settings.getNamespace())) {
            throw new ModuleStartException("the settings of configmap configuration is illegal.");
        }
        ConfigurationConfigmapInformer informer = new ConfigurationConfigmapInformer(this.settings);
        return new ConfigmapConfigurationWatcherRegister(this.settings, informer);
    }
}

