/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.tidb;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseModelExtension;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.joda.time.DateTime;

public class TiDBHistoryDeleteDAO
implements IHistoryDeleteDAO {
    private final JDBCHikariCPClient client;

    public TiDBHistoryDeleteDAO(JDBCHikariCPClient client) {
        this.client = client;
    }

    public void deleteHistory(Model model, String timeBucketColumnName, int ttl) throws IOException {
        SQLBuilder dataDeleteSQL = new SQLBuilder("delete from " + model.getName() + " where ").append(timeBucketColumnName).append("<= ? ").append(" and ").append(timeBucketColumnName).append(">= ? ").append(" limit 10000");
        try (Connection connection = this.client.getConnection();){
            long minTime;
            long deadline;
            if (model.isRecord()) {
                deadline = Long.parseLong(new DateTime().plusDays(-ttl).toString("yyyyMMddHHmmss"));
                minTime = 10000000000000L;
            } else {
                switch (model.getDownsampling()) {
                    case Minute: {
                        deadline = Long.parseLong(new DateTime().plusDays(-ttl).toString("yyyyMMddHHmm"));
                        minTime = 100000000000L;
                        break;
                    }
                    case Hour: {
                        deadline = Long.parseLong(new DateTime().plusDays(-ttl).toString("yyyyMMddHH"));
                        minTime = 1000000000L;
                        break;
                    }
                    case Day: {
                        deadline = Long.parseLong(new DateTime().plusDays(-ttl).toString("yyyyMMdd"));
                        minTime = 10000000L;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            while (this.client.executeUpdate(connection, dataDeleteSQL.toString(), new Object[]{deadline, minTime}) > 0) {
            }
            for (SQLDatabaseModelExtension.AdditionalTable additionalTable : model.getSqlDBModelExtension().getAdditionalTables().values()) {
                SQLBuilder additionalTableDeleteSQL = new SQLBuilder("delete from " + additionalTable.getName() + " where ").append(timeBucketColumnName).append("<= ? ").append(" and ").append(timeBucketColumnName).append(">= ? ").append(" limit 10000");
                while (this.client.executeUpdate(connection, additionalTableDeleteSQL.toString(), new Object[]{deadline, minTime}) > 0) {
                }
            }
        }
        catch (SQLException | JDBCClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

