/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.webapp;

import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Order(value=-1)
@Configuration
public class GlobalErrorWebExceptionHandler
implements ErrorWebExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalErrorWebExceptionHandler.class);

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ServerHttpResponse response = exchange.getResponse();
        response.getHeaders().setContentType(MediaType.TEXT_HTML);
        return response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            try {
                return bufferFactory.wrap(StreamUtils.copyToByteArray((InputStream)new ClassPathResource("/public/index.html").getInputStream()));
            }
            catch (IOException e) {
                log.error("There was an error completing the action.", ex);
                return bufferFactory.wrap(new byte[0]);
            }
        }));
    }
}

