/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.generator.Generator;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.source.Segment;
import org.apache.skywalking.restapi.SpanGenerator;
import org.apache.skywalking.restapi.TagGenerator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public final class SegmentRequest
implements Generator<Segment> {
    private Generator<String> segmentId;
    private Generator<String> traceId;
    private Generator<String> serviceName;
    private Generator<String> serviceInstanceName;
    private Generator<String> endpointName;
    private Generator<Long> startTime;
    private Generator<Long> latency;
    private Generator<Long> error;
    private Generator<List<TagGenerator>> tags;
    private Generator<List<SpanGenerator>> spans;

    @Override
    public Segment next() {
        String traceId = this.getTraceId().next();
        String serviceName = this.getServiceName().next();
        String serviceInstanceName = this.getServiceInstanceName().next();
        String endpointName = this.getEndpointName().next();
        String segmentId = this.getSegmentId().next();
        SegmentObject segmentObj = SegmentObject.newBuilder().setTraceId(traceId).setTraceSegmentId(segmentId).addAllSpans((Iterable)this.getSpans().next().stream().map(SpanGenerator::next).collect(Collectors.toList())).setService(serviceName).setServiceInstance(serviceInstanceName).build();
        this.getSpans().reset();
        Segment segment = new Segment();
        segment.setSegmentId(segmentId);
        segment.setTraceId(traceId);
        segment.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)true));
        segment.setServiceInstanceId(IDManager.ServiceInstanceID.buildId((String)segment.getServiceId(), (String)serviceInstanceName));
        segment.setEndpointId(IDManager.EndpointID.buildId((String)segment.getServiceId(), (String)endpointName));
        segment.setStartTime(this.getStartTime().next().longValue());
        segment.setLatency(this.getLatency().next().intValue());
        segment.setIsError(this.getError().next().intValue());
        segment.setTimeBucket(TimeBucket.getRecordTimeBucket((long)segment.getStartTime()));
        segment.setTags(this.getTags().next().stream().map(TagGenerator::next).collect(Collectors.toList()));
        segment.setDataBinary(segmentObj.toByteArray());
        return segment;
    }

    @Generated
    public SegmentRequest() {
    }

    @Generated
    public Generator<String> getSegmentId() {
        return this.segmentId;
    }

    @Generated
    public Generator<String> getTraceId() {
        return this.traceId;
    }

    @Generated
    public Generator<String> getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Generator<String> getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public Generator<String> getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public Generator<Long> getStartTime() {
        return this.startTime;
    }

    @Generated
    public Generator<Long> getLatency() {
        return this.latency;
    }

    @Generated
    public Generator<Long> getError() {
        return this.error;
    }

    @Generated
    public Generator<List<TagGenerator>> getTags() {
        return this.tags;
    }

    @Generated
    public Generator<List<SpanGenerator>> getSpans() {
        return this.spans;
    }

    @Generated
    public void setSegmentId(Generator<String> segmentId) {
        this.segmentId = segmentId;
    }

    @Generated
    public void setTraceId(Generator<String> traceId) {
        this.traceId = traceId;
    }

    @Generated
    public void setServiceName(Generator<String> serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceInstanceName(Generator<String> serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public void setEndpointName(Generator<String> endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setStartTime(Generator<Long> startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setLatency(Generator<Long> latency) {
        this.latency = latency;
    }

    @Generated
    public void setError(Generator<Long> error) {
        this.error = error;
    }

    @Generated
    public void setTags(Generator<List<TagGenerator>> tags) {
        this.tags = tags;
    }

    @Generated
    public void setSpans(Generator<List<SpanGenerator>> spans) {
        this.spans = spans;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentRequest)) {
            return false;
        }
        SegmentRequest other = (SegmentRequest)o;
        Generator<String> this$segmentId = this.getSegmentId();
        Generator<String> other$segmentId = other.getSegmentId();
        if (this$segmentId == null ? other$segmentId != null : !this$segmentId.equals(other$segmentId)) {
            return false;
        }
        Generator<String> this$traceId = this.getTraceId();
        Generator<String> other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Generator<String> this$serviceName = this.getServiceName();
        Generator<String> other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        Generator<String> this$serviceInstanceName = this.getServiceInstanceName();
        Generator<String> other$serviceInstanceName = other.getServiceInstanceName();
        if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
            return false;
        }
        Generator<String> this$endpointName = this.getEndpointName();
        Generator<String> other$endpointName = other.getEndpointName();
        if (this$endpointName == null ? other$endpointName != null : !this$endpointName.equals(other$endpointName)) {
            return false;
        }
        Generator<Long> this$startTime = this.getStartTime();
        Generator<Long> other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        Generator<Long> this$latency = this.getLatency();
        Generator<Long> other$latency = other.getLatency();
        if (this$latency == null ? other$latency != null : !this$latency.equals(other$latency)) {
            return false;
        }
        Generator<Long> this$error = this.getError();
        Generator<Long> other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        Generator<List<TagGenerator>> this$tags = this.getTags();
        Generator<List<TagGenerator>> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        Generator<List<SpanGenerator>> this$spans = this.getSpans();
        Generator<List<SpanGenerator>> other$spans = other.getSpans();
        return !(this$spans == null ? other$spans != null : !this$spans.equals(other$spans));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Generator<String> $segmentId = this.getSegmentId();
        result = result * 59 + ($segmentId == null ? 43 : $segmentId.hashCode());
        Generator<String> $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Generator<String> $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        Generator<String> $serviceInstanceName = this.getServiceInstanceName();
        result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
        Generator<String> $endpointName = this.getEndpointName();
        result = result * 59 + ($endpointName == null ? 43 : $endpointName.hashCode());
        Generator<Long> $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        Generator<Long> $latency = this.getLatency();
        result = result * 59 + ($latency == null ? 43 : $latency.hashCode());
        Generator<Long> $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        Generator<List<TagGenerator>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        Generator<List<SpanGenerator>> $spans = this.getSpans();
        result = result * 59 + ($spans == null ? 43 : $spans.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SegmentRequest(segmentId=" + this.getSegmentId() + ", traceId=" + this.getTraceId() + ", serviceName=" + this.getServiceName() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", endpointName=" + this.getEndpointName() + ", startTime=" + this.getStartTime() + ", latency=" + this.getLatency() + ", error=" + this.getError() + ", tags=" + this.getTags() + ", spans=" + this.getSpans() + ")";
    }
}

