/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.RequestObject;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.Segment;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.restapi.SegmentRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentGeneratorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentGeneratorHandler.class);
    private final SourceReceiver sourceReceiver;
    private final Map<String, Future<?>> futures = new ConcurrentHashMap();
    private final EventLoopGroup eventLoopGroup = EventLoopGroups.newEventLoopGroup((int)10);

    public SegmentGeneratorHandler(ModuleManager manager) {
        this.sourceReceiver = (SourceReceiver)manager.find("core").provider().getService(SourceReceiver.class);
    }

    @Post(value="/mock-data/segments/tasks")
    public HttpResponse generateMockSegments(@Default(value="0") @Param(value="size") int size, @Default(value="0") @Param(value="qps") int qps, @RequestObject SegmentRequest request) {
        if (size > 0 && qps > 0) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"size and qps can't be both set");
        }
        log.info("Generate {} mock segments, qps: {}, template: {}", new Object[]{size, qps, request});
        IntConsumer generator = unused -> {
            Segment segment = request.next();
            log.debug("Generating segment: {}", (Object)segment);
            this.sourceReceiver.receive((ISource)segment);
        };
        String requestId = UUID.randomUUID().toString();
        Object future = size > 0 ? this.eventLoopGroup.submit(() -> IntStream.range(0, size).forEach(generator)) : this.eventLoopGroup.scheduleAtFixedRate(() -> IntStream.range(0, qps).forEach(generator), 0L, 1L, TimeUnit.SECONDS);
        this.futures.put(requestId, (Future<?>)future);
        future.addListener(f -> {
            if (f.isDone()) {
                this.futures.remove(requestId);
                log.info("Generate mock segments finished: {}, requestId: {}", (Object)f.isSuccess(), (Object)requestId);
            }
            if (f.cause() != null && !(f.cause() instanceof CancellationException)) {
                log.error("Exception in future: ", f.cause());
            }
        });
        return HttpResponse.of((MediaType)MediaType.PLAIN_TEXT, (String)requestId);
    }

    @Delete(value="/mock-data/segments/task")
    public HttpResponse cancelRequest(@Param(value="requestId") String requestId) {
        Future<?> future = this.futures.get(requestId);
        if (future == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"No such request: %s", (Object[])new Object[]{requestId});
        }
        log.info("Cancelling request: {}", (Object)requestId);
        future.cancel(true);
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    @Delete(value="/mock-data/segments/tasks")
    public HttpResponse cancelAllRequests() {
        this.futures.forEach((t, u) -> {
            log.info("Cancelling request: {}", t);
            u.cancel(true);
        });
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    @ProducesJson
    @Get(value="/mock-data/segments/tasks")
    public Set<String> listRequest() {
        return this.futures.keySet();
    }
}

