/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public final class StringGenerator
implements Generator<String> {
    private final int length;
    private final String prefix;
    private final boolean letters;
    private final boolean numbers;
    private final boolean limitedDomain;
    private final Random random = ThreadLocalRandom.current();
    private final Set<String> domain = new HashSet<String>();

    public StringGenerator(Builder builder) {
        this.length = builder.length;
        this.prefix = builder.prefix;
        this.letters = builder.letters;
        this.numbers = builder.numbers;
        boolean bl = this.limitedDomain = builder.domainSize > 0;
        if (this.limitedDomain) {
            while (this.domain.size() < builder.domainSize) {
                String r = RandomStringUtils.random((int)this.length, (boolean)this.letters, (boolean)this.numbers);
                if (!Strings.isNullOrEmpty((String)builder.prefix)) {
                    this.domain.add(builder.prefix + r);
                    continue;
                }
                this.domain.add(r);
            }
        }
    }

    @Override
    public String next() {
        if (!this.limitedDomain) {
            return Strings.nullToEmpty((String)this.prefix) + RandomStringUtils.random((int)this.length, (boolean)this.letters, (boolean)this.numbers);
        }
        return (String)this.domain.stream().skip(this.random.nextInt(this.domain.size())).findFirst().orElseThrow(() -> new RuntimeException("Should never happen"));
    }

    public String toString() {
        return String.valueOf(this.next());
    }

    public static class Builder {
        private int length;
        private String prefix;
        private boolean letters;
        private boolean numbers;
        private int domainSize;

        public StringGenerator build() {
            return new StringGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public boolean isLetters() {
            return this.letters;
        }

        @Generated
        public boolean isNumbers() {
            return this.numbers;
        }

        @Generated
        public int getDomainSize() {
            return this.domainSize;
        }

        @Generated
        public void setLength(int length) {
            this.length = length;
        }

        @Generated
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Generated
        public void setLetters(boolean letters) {
            this.letters = letters;
        }

        @Generated
        public void setNumbers(boolean numbers) {
            this.numbers = numbers;
        }

        @Generated
        public void setDomainSize(int domainSize) {
            this.domainSize = domainSize;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isLetters() != other.isLetters()) {
                return false;
            }
            if (this.isNumbers() != other.isNumbers()) {
                return false;
            }
            if (this.getDomainSize() != other.getDomainSize()) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isLetters() ? 79 : 97);
            result = result * 59 + (this.isNumbers() ? 79 : 97);
            result = result * 59 + this.getDomainSize();
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StringGenerator.Builder(length=" + this.getLength() + ", prefix=" + this.getPrefix() + ", letters=" + this.isLetters() + ", numbers=" + this.isNumbers() + ", domainSize=" + this.getDomainSize() + ")";
        }
    }
}

