/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public final class BoolGenerator
implements Generator<Boolean> {
    private final Random random = ThreadLocalRandom.current();
    private final double possibility;

    public BoolGenerator(Builder builder) {
        this.possibility = builder.possibility;
    }

    @Override
    public Boolean next() {
        return this.random.nextDouble() < this.possibility;
    }

    public String toString() {
        return String.valueOf(this.next());
    }

    public static class Builder {
        private double possibility = 0.5;

        public BoolGenerator build() {
            return new BoolGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public double getPossibility() {
            return this.possibility;
        }

        @Generated
        public void setPossibility(double possibility) {
            this.possibility = possibility;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Double.compare(this.getPossibility(), other.getPossibility()) == 0;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $possibility = Double.doubleToLongBits(this.getPossibility());
            result = result * 59 + (int)($possibility >>> 32 ^ $possibility);
            return result;
        }

        @Generated
        public String toString() {
            return "BoolGenerator.Builder(possibility=" + this.getPossibility() + ")";
        }
    }
}

