/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.handler;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ConsumesProtobuf;
import com.linecorp.armeria.server.annotation.Post;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.ConsumesThrift;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.UnzippingBytesRequestConverter;
import org.apache.skywalking.oap.server.receiver.zipkin.trace.SpanForward;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.codec.SpanBytesDecoder;

public class ZipkinSpanHTTPHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZipkinSpanHTTPHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private final SpanForward spanForward;

    public ZipkinSpanHTTPHandler(ZipkinReceiverConfig config, ModuleManager manager) {
        this.spanForward = new SpanForward(config, manager);
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("trace_in_latency", "The process latency of trace data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"zipkin-http"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("trace_analysis_error_count", "The error number of trace analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"zipkin-http"}));
    }

    @Post(value="/api/v2/spans")
    public HttpResponse collectV2Spans(ServiceRequestContext ctx, HttpRequest req) {
        return this.doCollectSpans(SpanBytesDecoder.JSON_V2, ctx, req);
    }

    @Post(value="/api/v2/spans")
    @ConsumesJson
    public HttpResponse collectV2JsonSpans(ServiceRequestContext ctx, HttpRequest req) {
        return this.doCollectSpans(SpanBytesDecoder.JSON_V2, ctx, req);
    }

    @Post(value="/api/v2/spans")
    @ConsumesProtobuf
    public HttpResponse collectV2ProtobufSpans(ServiceRequestContext ctx, HttpRequest req) {
        return this.doCollectSpans(SpanBytesDecoder.PROTO3, ctx, req);
    }

    @Post(value="/api/v1/spans")
    public HttpResponse collectV1Spans(ServiceRequestContext ctx, HttpRequest req) {
        return this.doCollectSpans(SpanBytesDecoder.JSON_V1, ctx, req);
    }

    @Post(value="/api/v1/spans")
    @ConsumesJson
    public HttpResponse collectV1JsonSpans(ServiceRequestContext ctx, HttpRequest req) {
        return this.doCollectSpans(SpanBytesDecoder.JSON_V1, ctx, req);
    }

    @Post(value="/api/v1/spans")
    @ConsumesThrift
    public HttpResponse collectV1ThriftSpans(ServiceRequestContext ctx, HttpRequest req) {
        return this.doCollectSpans(SpanBytesDecoder.THRIFT, ctx, req);
    }

    HttpResponse doCollectSpans(SpanBytesDecoder decoder, ServiceRequestContext ctx, HttpRequest req) {
        HistogramMetrics.Timer timer = this.histogram.createTimer();
        HttpResponse response = HttpResponse.from((CompletionStage)req.aggregate().thenApply(request -> {
            HttpData httpData = UnzippingBytesRequestConverter.convertRequest(ctx, request);
            List spanList = decoder.decodeList(httpData.byteBuf().nioBuffer());
            this.spanForward.send(spanList);
            return HttpResponse.of((HttpStatus)HttpStatus.OK);
        }));
        response.whenComplete().handle((unused, throwable) -> {
            if (Objects.nonNull(throwable)) {
                this.errorCounter.inc();
            }
            timer.close();
            return null;
        });
        return response;
    }
}

