/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin;

import com.linecorp.armeria.common.HttpMethod;
import java.util.Arrays;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverModule;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.ZipkinSpanHTTPHandler;
import org.apache.skywalking.oap.server.receiver.zipkin.kafka.KafkaHandler;

public class ZipkinReceiverProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private final ZipkinReceiverConfig config = new ZipkinReceiverConfig();
    private HTTPServer httpServer;
    private KafkaHandler kafkaHandler;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return ZipkinReceiverModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        if (this.config.getSampleRate() < 0 || this.config.getSampleRate() > 10000) {
            throw new IllegalArgumentException("sampleRate: " + this.config.getSampleRate() + ", should be between 0 and 10000");
        }
        if (this.config.isEnableHttpCollector()) {
            HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.config.getRestHost()).port(this.config.getRestPort()).contextPath(this.config.getRestContextPath()).idleTimeOut(this.config.getRestIdleTimeOut()).maxThreads(this.config.getRestMaxThreads()).acceptQueueSize(this.config.getRestAcceptQueueSize()).build();
            this.httpServer = new HTTPServer(httpServerConfig);
            this.httpServer.initialize();
            this.httpServer.addHandler((Object)new ZipkinSpanHTTPHandler(this.config, this.getManager()), Arrays.asList(HttpMethod.POST, HttpMethod.GET));
        }
        if (this.config.isEnableKafkaCollector()) {
            this.kafkaHandler = new KafkaHandler(this.config, this.getManager());
        }
    }

    public void notifyAfterCompleted() throws ModuleStartException {
        if (this.config.isEnableHttpCollector()) {
            this.httpServer.start();
        }
        if (this.config.isEnableKafkaCollector()) {
            this.kafkaHandler.start();
        }
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core"};
    }
}

