/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.etcd;

import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.etcd.EtcdConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.etcd.EtcdServerSettings;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConfigurationProvider
extends AbstractConfigurationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdConfigurationProvider.class);
    private final EtcdServerSettings settings = new EtcdServerSettings();

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        if (StringUtil.isEmpty((String)this.settings.getEndpoints())) {
            throw new ModuleStartException("Etcd endpoints cannot be null or empty.");
        }
        try {
            return new EtcdConfigWatcherRegister(this.settings);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String name() {
        return "etcd";
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.settings;
    }
}

