/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.starter;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.version.Version;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.starter.config.ApplicationConfigLoader;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAPServerBootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAPServerBootstrap.class);

    public static void start() {
        String mode = System.getProperty("mode");
        RunningMode.setMode((String)mode);
        ApplicationConfigLoader configLoader = new ApplicationConfigLoader();
        ModuleManager manager = new ModuleManager();
        try {
            ApplicationConfiguration applicationConfiguration = configLoader.load();
            manager.init(applicationConfiguration);
            ((MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("uptime", "oap server start up time", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)System.currentTimeMillis() / 1000.0);
            log.info("Version of OAP: {}", (Object)Version.CURRENT);
            if (RunningMode.isInitMode()) {
                log.info("OAP starts up in init mode successfully, exit now...");
                System.exit(0);
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            System.exit(1);
        }
    }
}

