/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.skywalking.library.kubernetes.KubernetesClient;
import org.apache.skywalking.library.kubernetes.KubernetesServiceListener;

public enum KubernetesServiceWatcher implements ResourceEventHandler<V1Service>
{
    INSTANCE;

    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("KubernetesServiceWatcher-%d").setDaemon(true).build());
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<KubernetesServiceListener> listeners = new CopyOnWriteArraySet<KubernetesServiceListener>();

    public void start() throws IOException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        KubernetesClient.setDefault();
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedInformerFactory factory = new SharedInformerFactory(this.executor);
        this.listenServiceEvents(coreV1Api, factory);
        factory.startAllRegisteredInformers();
    }

    public KubernetesServiceWatcher addListener(KubernetesServiceListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        return this;
    }

    public void onAdd(V1Service service) {
        this.listeners.forEach(it -> it.onServiceAdded(service));
    }

    public void onUpdate(V1Service oldService, V1Service newService) {
        this.listeners.forEach(it -> it.onServiceUpdated(oldService, newService));
    }

    public void onDelete(V1Service service, boolean deletedFinalStateUnknown) {
        this.listeners.forEach(it -> it.onServiceDeleted(service));
    }

    private void listenServiceEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listServiceForAllNamespacesCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Service.class, V1ServiceList.class).addEventHandler((ResourceEventHandler)this);
    }
}

