/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.skywalking.library.kubernetes.KubernetesClient;
import org.apache.skywalking.library.kubernetes.KubernetesPodListener;

public enum KubernetesPodWatcher implements ResourceEventHandler<V1Pod>
{
    INSTANCE;

    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("KubernetesPodWatcher-%d").setDaemon(true).build());
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<KubernetesPodListener> listeners = new CopyOnWriteArraySet<KubernetesPodListener>();

    public void start() throws IOException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        KubernetesClient.setDefault();
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedInformerFactory factory = new SharedInformerFactory(this.executor);
        this.listenPodEvents(coreV1Api, factory);
        factory.startAllRegisteredInformers();
    }

    public KubernetesPodWatcher addListener(KubernetesPodListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        return this;
    }

    public void onAdd(V1Pod pod) {
        this.listeners.forEach(it -> it.onPodAdded(pod));
    }

    public void onUpdate(V1Pod oldPod, V1Pod newPod) {
        this.listeners.forEach(it -> it.onPodUpdated(oldPod, newPod));
    }

    public void onDelete(V1Pod pod, boolean deletedFinalStateUnknown) {
        this.listeners.forEach(it -> it.onPodDeleted(pod));
    }

    private void listenPodEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listPodForAllNamespacesCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Pod.class, V1PodList.class).addEventHandler((ResourceEventHandler)this);
    }
}

