/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.skywalking.library.kubernetes.KubernetesClient;
import org.apache.skywalking.library.kubernetes.KubernetesNodeListener;

public enum KubernetesNodeWatcher implements ResourceEventHandler<V1Node>
{
    INSTANCE;

    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("KubernetesNodeWatcher-%d").setDaemon(true).build());
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<KubernetesNodeListener> listeners = new CopyOnWriteArraySet<KubernetesNodeListener>();

    public void start() throws IOException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        KubernetesClient.setDefault();
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedInformerFactory factory = new SharedInformerFactory(this.executor);
        this.listenNodeEvents(coreV1Api, factory);
        factory.startAllRegisteredInformers();
    }

    public KubernetesNodeWatcher addListener(KubernetesNodeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        return this;
    }

    public void onAdd(V1Node node) {
        this.listeners.forEach(it -> it.onNodeAdded(node));
    }

    public void onUpdate(V1Node oldNode, V1Node newNode) {
        this.listeners.forEach(it -> it.onNodeUpdated(oldNode, newNode));
    }

    public void onDelete(V1Node node, boolean deletedFinalStateUnknown) {
        this.listeners.forEach(it -> it.onNodeDeleted(node));
    }

    private void listenNodeEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listNodeCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Node.class, V1NodeList.class).addEventHandler((ResourceEventHandler)this);
    }
}

