/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.skywalking.library.kubernetes.KubernetesClient;
import org.apache.skywalking.library.kubernetes.KubernetesEndpointsListener;

public enum KubernetesEndpointWatcher implements ResourceEventHandler<V1Endpoints>
{
    INSTANCE;

    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("KubernetesEndpointWatcher-%d").setDaemon(true).build());
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<KubernetesEndpointsListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void start() throws IOException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        KubernetesClient.setDefault();
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedInformerFactory factory = new SharedInformerFactory(this.executor);
        this.listenEndpointEvents(coreV1Api, factory);
        factory.startAllRegisteredInformers();
    }

    public KubernetesEndpointWatcher addListener(KubernetesEndpointsListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        return this;
    }

    public void onAdd(V1Endpoints endpoints) {
        this.listeners.forEach(it -> it.onEndpointsAdded(endpoints));
    }

    public void onUpdate(V1Endpoints oldEndpoints, V1Endpoints newEndpoints) {
        this.listeners.forEach(it -> it.onEndpointsUpdated(oldEndpoints, newEndpoints));
    }

    public void onDelete(V1Endpoints endpoints, boolean deletedFinalStateUnknown) {
        this.listeners.forEach(it -> it.onEndpointsDeleted(endpoints));
    }

    private void listenEndpointEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listEndpointsForAllNamespacesCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Endpoints.class, V1EndpointsList.class).addEventHandler((ResourceEventHandler)this);
    }
}

