/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.BucketOrder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregation;

public final class TermsAggregationBuilder
implements AggregationBuilder {
    private final String name;
    private String field;
    private BucketOrder order;
    private Integer size;
    private ImmutableMap.Builder<String, Aggregation> subAggregations;
    private CollectMode collectMode;
    private ExecutionHint executionHint;

    TermsAggregationBuilder(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        this.name = name;
    }

    public TermsAggregationBuilder field(String field) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)field) ? 1 : 0) != 0, (Object)"field cannot be blank");
        this.field = field;
        return this;
    }

    public TermsAggregationBuilder order(BucketOrder order) {
        Objects.requireNonNull(order, "order");
        this.order = order;
        return this;
    }

    public TermsAggregationBuilder size(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size must be >= 0");
        this.size = size;
        return this;
    }

    public TermsAggregationBuilder subAggregation(Aggregation subAggregation) {
        Objects.requireNonNull(subAggregation, "subAggregation");
        this.subAggregations().put((Object)subAggregation.name(), (Object)subAggregation);
        return this;
    }

    public TermsAggregationBuilder subAggregation(AggregationBuilder subAggregationBuilder) {
        Objects.requireNonNull(subAggregationBuilder, "subAggregationBuilder");
        return this.subAggregation(subAggregationBuilder.build());
    }

    public TermsAggregationBuilder collectMode(CollectMode collectMode) {
        Objects.requireNonNull(collectMode, "collectMode");
        this.collectMode = collectMode;
        return this;
    }

    public TermsAggregationBuilder executionHint(ExecutionHint executionHint) {
        Objects.requireNonNull(executionHint, "executionHint");
        this.executionHint = executionHint;
        return this;
    }

    @Override
    public TermsAggregation build() {
        ImmutableMap subAggregations = this.subAggregations == null ? null : this.subAggregations.build();
        return new TermsAggregation(this.name, this.field, this.order, this.size, (ImmutableMap<String, Aggregation>)subAggregations, this.collectMode, this.executionHint);
    }

    private ImmutableMap.Builder<String, Aggregation> subAggregations() {
        if (this.subAggregations == null) {
            this.subAggregations = ImmutableMap.builder();
        }
        return this.subAggregations;
    }

    public static enum ExecutionHint {
        GLOBAL_ORDINALS("global_ordinals"),
        MAP("map");

        final String value;

        private ExecutionHint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum CollectMode {
        BREADTH_FIRST("breadth_first"),
        DEPTH_FIRST("depth_first");

        final String value;

        private CollectMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

