/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SearchParams
implements Iterable<Map.Entry<String, Object>> {
    private static final String IGNORE_UNAVAILABLE = "ignore_unavailable";
    private static final String ALLOW_NO_INDICES = "allow_no_indices";
    private static final String EXPAND_WILDCARDS = "expand_wildcards";
    private static final String SCROLL = "scroll";
    private final Map<String, Object> params = new HashMap<String, Object>();

    public SearchParams ignoreUnavailable(boolean ignoreUnavailable) {
        this.params.put(IGNORE_UNAVAILABLE, ignoreUnavailable);
        return this;
    }

    public SearchParams allowNoIndices(boolean allowNoIndices) {
        this.params.put(ALLOW_NO_INDICES, allowNoIndices);
        return this;
    }

    public SearchParams expandWildcards(String wildcards) {
        this.params.put(EXPAND_WILDCARDS, wildcards);
        return this;
    }

    public SearchParams scroll(Duration contextRetention) {
        Preconditions.checkArgument((contextRetention != null && !contextRetention.isNegative() && !contextRetention.isZero() ? 1 : 0) != 0, (String)"contextRetention must be positive, but was %s", (Object)contextRetention);
        this.params.put(SCROLL, contextRetention.getSeconds() + "s");
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.params.entrySet().iterator();
    }
}

