/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.client;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpStatus;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplate;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateClient.class);
    private final CompletableFuture<ElasticSearchVersion> version;
    private final WebClient client;

    public boolean exists(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().exists(name)).aggregate().thenApply(response -> {
            HttpStatus status = response.status();
            if (status == HttpStatus.OK) {
                return true;
            }
            if (status == HttpStatus.NOT_FOUND) {
                return false;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to check whether template {} exists", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to check whether template {} exists {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public Optional<IndexTemplate> get(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().get(name)).aggregate().thenApply(response -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get index template {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to get index template {}, {}", (Object)name, result);
            }
        });
        return (Optional)((CompletableFuture)future).get();
    }

    public boolean delete(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().delete(name)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to delete index template {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to delete index template {}, {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public boolean createOrUpdate(String name, Map<String, Object> settings, Mappings mappings, int order) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().template().createOrUpdate(name, settings, mappings, order)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to create / update index template {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to create / update index template {}, {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    @Generated
    public TemplateClient(CompletableFuture<ElasticSearchVersion> version, WebClient client) {
        this.version = version;
        this.client = client;
    }
}

