/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.bulk;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearch;
import org.apache.skywalking.library.elasticsearch.bulk.BulkProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BulkProcessorBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkProcessorBuilder.class);
    private int bulkActions = -1;
    private Duration flushInterval;
    private int concurrentRequests = 2;

    public BulkProcessorBuilder bulkActions(int bulkActions) {
        Preconditions.checkArgument((bulkActions > 0 ? 1 : 0) != 0, (Object)"bulkActions must be positive");
        this.bulkActions = bulkActions;
        return this;
    }

    public BulkProcessorBuilder flushInterval(Duration flushInterval) {
        this.flushInterval = Objects.requireNonNull(flushInterval, "flushInterval");
        return this;
    }

    public BulkProcessorBuilder concurrentRequests(int concurrentRequests) {
        Preconditions.checkArgument((concurrentRequests >= 0 ? 1 : 0) != 0, (Object)"concurrentRequests must be >= 0");
        this.concurrentRequests = concurrentRequests;
        return this;
    }

    public BulkProcessor build(AtomicReference<ElasticSearch> es) {
        return new BulkProcessor(es, this.bulkActions, this.flushInterval, this.concurrentRequests);
    }

    @Generated
    public BulkProcessorBuilder() {
    }
}

