/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.bulk;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearch;
import org.apache.skywalking.library.elasticsearch.bulk.BulkProcessorBuilder;
import org.apache.skywalking.library.elasticsearch.requests.IndexRequest;
import org.apache.skywalking.library.elasticsearch.requests.UpdateRequest;
import org.apache.skywalking.library.elasticsearch.requests.factory.RequestFactory;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BulkProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkProcessor.class);
    private final ArrayBlockingQueue<Holder> requests;
    private final AtomicReference<ElasticSearch> es;
    private final int bulkActions;
    private final Semaphore semaphore;

    public static BulkProcessorBuilder builder() {
        return new BulkProcessorBuilder();
    }

    BulkProcessor(AtomicReference<ElasticSearch> es, int bulkActions, Duration flushInterval, int concurrentRequests) {
        Objects.requireNonNull(flushInterval, "flushInterval");
        this.es = Objects.requireNonNull(es, "es");
        this.bulkActions = bulkActions;
        this.semaphore = new Semaphore(concurrentRequests > 0 ? concurrentRequests : 1);
        this.requests = new ArrayBlockingQueue(bulkActions + 1);
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r);
            thread.setName("ElasticSearch BulkProcessor");
            return thread;
        });
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        scheduler.scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(this::flush, t -> log.error("flush data to ES failure:", t)), 0L, flushInterval.getSeconds(), TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> add(IndexRequest request) {
        return this.internalAdd(request);
    }

    public CompletableFuture<Void> add(UpdateRequest request) {
        return this.internalAdd(request);
    }

    private CompletableFuture<Void> internalAdd(Object request) {
        Objects.requireNonNull(request, "request");
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        this.requests.put(new Holder(f, request));
        this.flushIfNeeded();
        return f;
    }

    private void flushIfNeeded() {
        if (this.requests.size() >= this.bulkActions) {
            this.flush();
        }
    }

    public void flush() {
        if (this.requests.isEmpty()) {
            return;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            log.error("Interrupted when trying to get semaphore to execute bulk requests", (Throwable)e);
            return;
        }
        ArrayList<Holder> batch = new ArrayList<Holder>(this.requests.size());
        this.requests.drainTo(batch);
        CompletableFuture<Void> flush = this.doFlush(batch);
        flush.whenComplete((ignored1, ignored2) -> this.semaphore.release());
        flush.join();
    }

    private CompletableFuture<Void> doFlush(List<Holder> batch) {
        log.debug("Executing bulk with {} requests", (Object)batch.size());
        if (batch.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage future = this.es.get().version().thenCompose(v -> {
            try {
                RequestFactory rf = v.requestFactory();
                ArrayList<byte[]> bs = new ArrayList<byte[]>();
                for (Holder holder : batch) {
                    bs.add(v.codec().encode(holder.request));
                    bs.add("\n".getBytes());
                }
                ByteBuf content = Unpooled.wrappedBuffer((byte[][])((byte[][])bs.toArray((T[])new byte[0][])));
                return this.es.get().client().execute(rf.bulk().bulk(content)).aggregate().thenAccept(response -> {
                    HttpStatus status = response.status();
                    if (status != HttpStatus.OK) {
                        throw new RuntimeException(response.contentUtf8());
                    }
                });
            }
            catch (Exception e) {
                return (CompletionStage)Exceptions.throwUnsafely((Throwable)e);
            }
        });
        ((CompletableFuture)future).whenComplete((ignored, exception) -> {
            if (exception != null) {
                batch.stream().map(it -> ((Holder)it).future).forEach(it -> it.completeExceptionally((Throwable)exception));
                log.error("Failed to execute requests in bulk", exception);
            } else {
                log.debug("Succeeded to execute {} requests in bulk", (Object)batch.size());
                batch.stream().map(it -> ((Holder)it).future).forEach(it -> it.complete(null));
            }
        });
        return future;
    }

    static class Holder {
        private final CompletableFuture<Void> future;
        private final Object request;

        @Generated
        public Holder(CompletableFuture<Void> future, Object request) {
            this.future = future;
            this.request = request;
        }
    }
}

