/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.auth.AuthToken;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearch;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticSearchBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchBuilder.class);
    private static final int NUM_PROC = Runtime.getRuntime().availableProcessors();
    private SessionProtocol protocol = SessionProtocol.HTTP;
    private String username;
    private String password;
    private Duration healthCheckRetryInterval = Duration.ofSeconds(30L);
    private final ImmutableList.Builder<String> endpoints = ImmutableList.builder();
    private String trustStorePath;
    private String trustStorePass;
    private Duration responseTimeout = Duration.ofSeconds(15L);
    private Duration connectTimeout = Duration.ofMillis(500L);
    private Duration socketTimeout = Duration.ofSeconds(30L);
    private Consumer<Boolean> healthyListener;
    private int numHttpClientThread;

    public ElasticSearchBuilder protocol(String protocol) {
        Preconditions.checkArgument((boolean)StringUtil.isNotBlank((String)protocol), (Object)"protocol cannot be blank");
        this.protocol = SessionProtocol.of((String)protocol);
        return this;
    }

    public ElasticSearchBuilder username(String username) {
        this.username = Objects.requireNonNull(username, "username");
        return this;
    }

    public ElasticSearchBuilder password(String password) {
        this.password = Objects.requireNonNull(password, "password");
        return this;
    }

    public ElasticSearchBuilder endpoints(Iterable<String> endpoints) {
        Objects.requireNonNull(endpoints, "endpoints");
        this.endpoints.addAll(endpoints);
        return this;
    }

    public ElasticSearchBuilder endpoints(String ... endpoints) {
        return this.endpoints(Arrays.asList(endpoints));
    }

    public ElasticSearchBuilder healthCheckRetryInterval(Duration healthCheckRetryInterval) {
        Objects.requireNonNull(healthCheckRetryInterval, "healthCheckRetryInterval");
        this.healthCheckRetryInterval = healthCheckRetryInterval;
        return this;
    }

    public ElasticSearchBuilder trustStorePath(String trustStorePath) {
        Objects.requireNonNull(trustStorePath, "trustStorePath");
        this.trustStorePath = trustStorePath;
        return this;
    }

    public ElasticSearchBuilder trustStorePass(String trustStorePass) {
        Objects.requireNonNull(trustStorePass, "trustStorePass");
        this.trustStorePass = trustStorePass;
        return this;
    }

    public ElasticSearchBuilder connectTimeout(int connectTimeout) {
        Preconditions.checkArgument((connectTimeout > 0 ? 1 : 0) != 0, (Object)"connectTimeout must be positive");
        this.connectTimeout = Duration.ofMillis(connectTimeout);
        return this;
    }

    public ElasticSearchBuilder responseTimeout(int responseTimeout) {
        Preconditions.checkArgument((responseTimeout >= 0 ? 1 : 0) != 0, (Object)"responseTimeout must be 0 or positive");
        this.responseTimeout = Duration.ofMillis(responseTimeout);
        return this;
    }

    public ElasticSearchBuilder socketTimeout(int socketTimeout) {
        Preconditions.checkArgument((socketTimeout > 0 ? 1 : 0) != 0, (Object)"socketTimeout must be positive");
        this.socketTimeout = Duration.ofMillis(socketTimeout);
        return this;
    }

    public ElasticSearchBuilder healthyListener(Consumer<Boolean> healthyListener) {
        Objects.requireNonNull(healthyListener, "healthyListener");
        this.healthyListener = healthyListener;
        return this;
    }

    public ElasticSearchBuilder numHttpClientThread(int numHttpClientThread) {
        this.numHttpClientThread = numHttpClientThread;
        return this;
    }

    public ElasticSearch build() {
        List endpoints = this.endpoints.build().stream().filter(StringUtil::isNotBlank).map(Endpoint::parse).collect(Collectors.toList());
        ClientFactoryBuilder factoryBuilder = ClientFactory.builder().connectTimeout(this.connectTimeout).idleTimeout(this.socketTimeout).useHttp2Preface(false).workerGroup(this.numHttpClientThread > 0 ? this.numHttpClientThread : NUM_PROC);
        if (StringUtil.isNotBlank((String)this.trustStorePath)) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore truststore = KeyStore.getInstance("jks");
            try (InputStream is = Files.newInputStream(Paths.get(this.trustStorePath, new String[0]), new OpenOption[0]);){
                truststore.load(is, this.trustStorePass.toCharArray());
            }
            trustManagerFactory.init(truststore);
            factoryBuilder.tlsCustomizer(sslContextBuilder -> sslContextBuilder.trustManager(trustManagerFactory));
        }
        ClientFactory clientFactory = factoryBuilder.build();
        HealthCheckedEndpointGroupBuilder endpointGroupBuilder = HealthCheckedEndpointGroup.builder((EndpointGroup)EndpointGroup.of(endpoints), (String)"_cluster/health").protocol(this.protocol).useGet(true).clientFactory(clientFactory).retryInterval(this.healthCheckRetryInterval).withClientOptions(options -> {
            options.decorator(LoggingClient.builder().logger(log).newDecorator());
            options.decorator((delegate, ctx, req) -> {
                ctx.logBuilder().name("health-check");
                return delegate.execute(ctx, req);
            });
            return options;
        });
        if (StringUtil.isNotBlank((String)this.username) && StringUtil.isNotBlank((String)this.password)) {
            endpointGroupBuilder.auth((AuthToken)AuthToken.ofBasic((String)this.username, (String)this.password));
        }
        HealthCheckedEndpointGroup endpointGroup = endpointGroupBuilder.build();
        return new ElasticSearch(this.protocol, this.username, this.password, (EndpointGroup)endpointGroup, clientFactory, this.healthyListener, this.responseTimeout);
    }
}

