/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.client.retry.RetryRule;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.auth.AuthToken;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchBuilder;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.client.AliasClient;
import org.apache.skywalking.library.elasticsearch.client.DocumentClient;
import org.apache.skywalking.library.elasticsearch.client.IndexClient;
import org.apache.skywalking.library.elasticsearch.client.SearchClient;
import org.apache.skywalking.library.elasticsearch.client.TemplateClient;
import org.apache.skywalking.library.elasticsearch.requests.search.Scroll;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticSearch
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearch.class);
    private final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final WebClient client;
    private final CompletableFuture<ElasticSearchVersion> version;
    private final EndpointGroup endpointGroup;
    private final ClientFactory clientFactory;
    private final Consumer<List<Endpoint>> healthyEndpointListener;
    private final TemplateClient templateClient;
    private final IndexClient indexClient;
    private final DocumentClient documentClient;
    private final AliasClient aliasClient;
    private final SearchClient searchClient;

    ElasticSearch(SessionProtocol protocol, String username, String password, EndpointGroup endpointGroup, ClientFactory clientFactory, Consumer<Boolean> healthyListener, Duration responseTimeout) {
        this.endpointGroup = endpointGroup;
        this.clientFactory = clientFactory;
        this.healthyEndpointListener = healthyListener != null ? it -> healthyListener.accept(!it.isEmpty()) : it -> {};
        WebClientBuilder builder = WebClient.builder((SessionProtocol)protocol, (EndpointGroup)endpointGroup).factory(clientFactory).responseTimeout(responseTimeout).decorator(LoggingClient.builder().logger(log).newDecorator()).decorator(RetryingClient.builder((RetryRule)RetryRule.failsafe()).maxTotalAttempts(3).newDecorator());
        if (StringUtil.isNotBlank((String)username) && StringUtil.isNotBlank((String)password)) {
            builder.auth(AuthToken.ofBasic((String)username, (String)password));
        }
        this.client = builder.build();
        this.version = new CompletableFuture();
        this.templateClient = new TemplateClient(this.version, this.client);
        this.documentClient = new DocumentClient(this.version, this.client);
        this.indexClient = new IndexClient(this.version, this.client);
        this.aliasClient = new AliasClient(this.version, this.client);
        this.searchClient = new SearchClient(this.version, this.client);
    }

    public static ElasticSearchBuilder builder() {
        return new ElasticSearchBuilder();
    }

    public CompletableFuture<ElasticSearchVersion> connect() {
        CompletionStage future = this.client.get("/").aggregate().thenApply(response -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        ((CompletableFuture)future).whenComplete((v, throwable) -> {
            if (throwable != null) {
                RuntimeException cause = new RuntimeException("Failed to determine ElasticSearch version", (Throwable)throwable);
                this.version.completeExceptionally(cause);
                this.healthyEndpointListener.accept(Collections.emptyList());
                return;
            }
            log.info("ElasticSearch version is: {}", v);
            this.version.complete((ElasticSearchVersion)v);
        });
        this.endpointGroup.whenReady().thenAccept(this.healthyEndpointListener);
        this.endpointGroup.addListener(this.healthyEndpointListener);
        return future;
    }

    public TemplateClient templates() {
        return this.templateClient;
    }

    public DocumentClient documents() {
        return this.documentClient;
    }

    public IndexClient index() {
        return this.indexClient;
    }

    public AliasClient alias() {
        return this.aliasClient;
    }

    public SearchResponse search(Search search, SearchParams params, String ... index) {
        return this.searchClient.search(search, params, index);
    }

    public SearchResponse search(Search search, String ... index) {
        return this.search(search, (SearchParams)null, index);
    }

    public SearchResponse scroll(Duration contextRetention, String scrollId) {
        return this.searchClient.scroll(Scroll.builder().contextRetention(contextRetention).scrollId(scrollId).build());
    }

    public boolean deleteScrollContext(String scrollId) {
        return this.searchClient.deleteScrollContext(scrollId);
    }

    @Override
    public void close() {
        this.endpointGroup.removeListener(this.healthyEndpointListener);
        this.clientFactory.close();
        this.endpointGroup.close();
    }

    @Generated
    public WebClient client() {
        return this.client;
    }

    @Generated
    public CompletableFuture<ElasticSearchVersion> version() {
        return this.version;
    }
}

