/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.graphql;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.graphql.protocol.AbstractGraphqlService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class GraphqlDocServicePlugin
implements DocServicePlugin {
    @VisibleForTesting
    static final TypeSignature STRING = TypeSignature.ofBase((String)"string");
    @VisibleForTesting
    static final TypeSignature MAP = TypeSignature.ofBase((String)"map");
    @VisibleForTesting
    static final TypeSignature JSON = TypeSignature.ofBase((String)"json");
    static final String DEFAULT_METHOD_NAME = "doPost";

    public String name() {
        return "graphql";
    }

    public Set<Class<? extends Service<?, ?>>> supportedServiceTypes() {
        return ImmutableSet.of(AbstractGraphqlService.class);
    }

    public ServiceSpecification generateSpecification(Set<ServiceConfig> serviceConfigs, DocServiceFilter filter) {
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(filter, "filter");
        HashMap methodInfos = new HashMap();
        HashMap serviceDescription = new HashMap();
        serviceConfigs.forEach(sc -> {
            AbstractGraphqlService service = (AbstractGraphqlService)sc.service().as(AbstractGraphqlService.class);
            if (service != null) {
                String className = service.getClass().getName();
                String methodName = DEFAULT_METHOD_NAME;
                if (!filter.test(this.name(), className, DEFAULT_METHOD_NAME)) {
                    return;
                }
                GraphqlDocServicePlugin.addMethodInfo(methodInfos, sc.virtualHost().hostnamePattern(), service, sc.route());
            }
        });
        return GraphqlDocServicePlugin.generate(serviceDescription, methodInfos);
    }

    private static void addMethodInfo(Map<Class<?>, Set<MethodInfo>> methodInfos, String hostnamePattern, AbstractGraphqlService service, Route route) {
        EndpointInfo endpoint = GraphqlDocServicePlugin.endpointInfo(route, hostnamePattern);
        String name = DEFAULT_METHOD_NAME;
        List<FieldInfo> fieldInfos = GraphqlDocServicePlugin.fieldInfos();
        Class<?> clazz = service.getClass();
        MethodInfo methodInfo = new MethodInfo(DEFAULT_METHOD_NAME, JSON, fieldInfos, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of((Object)endpoint), HttpMethod.POST, null);
        methodInfos.computeIfAbsent(clazz, unused -> new HashSet()).add(methodInfo);
    }

    private static EndpointInfo endpointInfo(Route route, String hostnamePattern) {
        List paths = route.paths();
        return EndpointInfo.builder((String)hostnamePattern, (String)("exact:" + (String)paths.get(0))).availableMimeTypes(GraphqlDocServicePlugin.availableMimeTypes(route)).build();
    }

    private static Set<MediaType> availableMimeTypes(Route route) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set consumeTypes = route.consumes();
        builder.addAll((Iterable)consumeTypes);
        if (!consumeTypes.contains(MediaType.GRAPHQL)) {
            builder.add((Object)MediaType.GRAPHQL);
        }
        if (!consumeTypes.contains(MediaType.GRAPHQL_JSON)) {
            builder.add((Object)MediaType.GRAPHQL_JSON);
        }
        return builder.build();
    }

    private static List<FieldInfo> fieldInfos() {
        return ImmutableList.of((Object)FieldInfo.builder((String)"query", (TypeSignature)STRING).requirement(FieldRequirement.REQUIRED).build(), (Object)FieldInfo.builder((String)"operationName", (TypeSignature)STRING).requirement(FieldRequirement.OPTIONAL).build(), (Object)FieldInfo.builder((String)"variables", (TypeSignature)MAP).requirement(FieldRequirement.OPTIONAL).build(), (Object)FieldInfo.builder((String)"extensions", (TypeSignature)MAP).requirement(FieldRequirement.OPTIONAL).build());
    }

    @VisibleForTesting
    static ServiceSpecification generate(Map<Class<?>, String> serviceDescription, Map<Class<?>, Set<MethodInfo>> methodInfos) {
        Set serviceInfos = (Set)methodInfos.entrySet().stream().map(entry -> {
            Class service = (Class)entry.getKey();
            return new ServiceInfo(service.getName(), (Iterable)entry.getValue(), (String)serviceDescription.get(service));
        }).collect(ImmutableSet.toImmutableSet());
        return ServiceSpecification.generate((Iterable)serviceInfos, (T unused) -> null);
    }
}

