/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.slack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackhookCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackhookCallback.class);
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private static final Gson GSON = new Gson();
    private AlarmRulesWatcher alarmRulesWatcher;
    private RequestConfig requestConfig;

    public SlackhookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlarm(List<AlarmMessage> alarmMessages) {
        if (this.alarmRulesWatcher.getSlackSettings() == null || this.alarmRulesWatcher.getSlackSettings().getWebhooks().isEmpty()) {
            return;
        }
        CloseableHttpClient httpClient = HttpClients.custom().build();
        try {
            this.alarmRulesWatcher.getSlackSettings().getWebhooks().forEach(url -> {
                HttpPost post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                post.setHeader("Accept", HttpHeaderValues.APPLICATION_JSON.toString());
                post.setHeader("Content-Type", HttpHeaderValues.APPLICATION_JSON.toString());
                CloseableHttpResponse httpResponse = null;
                try {
                    JsonObject jsonObject = new JsonObject();
                    JsonArray jsonElements = new JsonArray();
                    alarmMessages.forEach(item -> jsonElements.add((JsonElement)GSON.fromJson(String.format(this.alarmRulesWatcher.getSlackSettings().getTextTemplate(), item.getAlarmMessage()), JsonObject.class)));
                    jsonObject.add("blocks", (JsonElement)jsonElements);
                    StringEntity entity = new StringEntity(GSON.toJson((JsonElement)jsonObject), ContentType.APPLICATION_JSON);
                    post.setEntity((HttpEntity)entity);
                    httpResponse = httpClient.execute((HttpUriRequest)post);
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine != null && statusLine.getStatusCode() != 200) {
                        log.error("Send slack alarm to {} failure. Response code: {}", url, (Object)statusLine.getStatusCode());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Alarm to JSON error, {} ", (Object)e.getMessage(), (Object)e);
                }
                catch (IOException e) {
                    log.error("Send slack alarm to {} failure.", url, (Object)e);
                }
                finally {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

