/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.pagerduty;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerDutyHookCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagerDutyHookCallback.class);
    private static final String PAGER_DUTY_EVENTS_API_V2_URL = "https://events.pagerduty.com/v2/enqueue";
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private static final Gson GSON = new Gson();
    private AlarmRulesWatcher alarmRulesWatcher;
    private RequestConfig requestConfig;

    public PagerDutyHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlarm(List<AlarmMessage> alarmMessages) {
        if (this.alarmRulesWatcher.getPagerDutySettings() == null || this.alarmRulesWatcher.getPagerDutySettings().getIntegrationKeys().isEmpty()) {
            return;
        }
        CloseableHttpClient httpClient = HttpClients.custom().build();
        try {
            this.alarmRulesWatcher.getPagerDutySettings().getIntegrationKeys().forEach(integrationKey -> alarmMessages.forEach(alarmMessage -> this.sendAlarmMessage(httpClient, (AlarmMessage)alarmMessage, (String)integrationKey)));
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlarmMessage(CloseableHttpClient httpClient, AlarmMessage alarmMessage, String integrationKey) {
        CloseableHttpResponse httpResponse = null;
        try {
            HttpPost post = new HttpPost(PAGER_DUTY_EVENTS_API_V2_URL);
            post.setConfig(this.requestConfig);
            post.setHeader("Accept", HttpHeaderValues.APPLICATION_JSON.toString());
            post.setHeader("Content-Type", HttpHeaderValues.APPLICATION_JSON.toString());
            post.setEntity((HttpEntity)this.getStringEntity(alarmMessage, integrationKey));
            httpResponse = httpClient.execute((HttpUriRequest)post);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() != 202) {
                log.error("send PagerDuty alarm to {} failure. Response code: {}, message: {} ", new Object[]{PAGER_DUTY_EVENTS_API_V2_URL, statusLine.getStatusCode(), EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8)});
            }
        }
        catch (Throwable e) {
            log.error("send PagerDuty alarm to {} failure.", (Object)PAGER_DUTY_EVENTS_API_V2_URL, (Object)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private StringEntity getStringEntity(AlarmMessage alarmMessage, String integrationKey) throws UnsupportedEncodingException {
        JsonObject body = new JsonObject();
        JsonObject payload = new JsonObject();
        payload.add("summary", (JsonElement)new JsonPrimitive(this.getFormattedMessage(alarmMessage)));
        payload.add("severity", (JsonElement)new JsonPrimitive("warning"));
        payload.add("source", (JsonElement)new JsonPrimitive("Skywalking"));
        body.add("payload", (JsonElement)payload);
        body.add("routing_key", (JsonElement)new JsonPrimitive(integrationKey));
        body.add("dedup_key", (JsonElement)new JsonPrimitive(UUID.randomUUID().toString()));
        body.add("event_action", (JsonElement)new JsonPrimitive("trigger"));
        return new StringEntity(GSON.toJson((JsonElement)body), ContentType.APPLICATION_JSON);
    }

    private String getFormattedMessage(AlarmMessage alarmMessage) {
        return String.format(this.alarmRulesWatcher.getPagerDutySettings().getTextTemplate(), alarmMessage.getAlarmMessage());
    }
}

