/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.grpc;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.grpc.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.grpc.AlarmServiceGrpc;
import org.apache.skywalking.oap.server.core.alarm.grpc.AlarmTags;
import org.apache.skywalking.oap.server.core.alarm.grpc.KeyStringValuePair;
import org.apache.skywalking.oap.server.core.alarm.grpc.Response;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCAlarmSetting;
import org.apache.skywalking.oap.server.library.client.grpc.GRPCClient;
import org.apache.skywalking.oap.server.library.util.GRPCStreamStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCCallback.class);
    private AlarmRulesWatcher alarmRulesWatcher;
    private GRPCAlarmSetting alarmSetting;
    private AlarmServiceGrpc.AlarmServiceStub alarmServiceStub;
    private GRPCClient grpcClient;

    public GRPCCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.alarmSetting = alarmRulesWatcher.getGrpchookSetting();
        if (this.alarmSetting != null && !this.alarmSetting.isEmptySetting()) {
            this.grpcClient = new GRPCClient(this.alarmSetting.getTargetHost(), this.alarmSetting.getTargetPort());
            this.grpcClient.connect();
            this.alarmServiceStub = AlarmServiceGrpc.newStub((Channel)this.grpcClient.getChannel());
        }
    }

    public void doAlarm(List<AlarmMessage> alarmMessage) {
        if (this.alarmSetting == null || this.alarmSetting.isEmptySetting()) {
            return;
        }
        this.onGRPCAlarmSettingUpdated(this.alarmRulesWatcher.getGrpchookSetting());
        final GRPCStreamStatus status = new GRPCStreamStatus();
        if (this.alarmServiceStub == null) {
            return;
        }
        StreamObserver<org.apache.skywalking.oap.server.core.alarm.grpc.AlarmMessage> streamObserver = ((AlarmServiceGrpc.AlarmServiceStub)this.alarmServiceStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).doAlarm(new StreamObserver<Response>(){

            public void onNext(Response response) {
            }

            public void onError(Throwable throwable) {
                status.done();
                if (log.isDebugEnabled()) {
                    log.debug("Send alarm message failed: {}", (Object)throwable.getMessage());
                }
            }

            public void onCompleted() {
                status.done();
                if (log.isDebugEnabled()) {
                    log.debug("Send alarm message successful.");
                }
            }
        });
        alarmMessage.forEach(message -> {
            AlarmMessage.Builder builder = org.apache.skywalking.oap.server.core.alarm.grpc.AlarmMessage.newBuilder();
            builder.setScopeId(message.getScopeId());
            builder.setScope(message.getScope());
            builder.setName(message.getName());
            builder.setId0(message.getId0());
            builder.setId1(message.getId1());
            builder.setRuleName(message.getRuleName());
            builder.setAlarmMessage(message.getAlarmMessage());
            builder.setStartTime(message.getStartTime());
            AlarmTags.Builder alarmTagsBuilder = AlarmTags.newBuilder();
            message.getTags().forEach(m -> alarmTagsBuilder.addData(KeyStringValuePair.newBuilder().setKey(m.getKey()).setValue(m.getValue()).build()));
            builder.setTags(alarmTagsBuilder.build());
            streamObserver.onNext((Object)builder.build());
        });
        streamObserver.onCompleted();
        long sleepTime = 0L;
        long cycle = 100L;
        while (!status.isDone()) {
            try {
                sleepTime += cycle;
                Thread.sleep(cycle);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug("Send {} alarm message to {}:{}.", new Object[]{alarmMessage.size(), this.alarmSetting.getTargetHost(), this.alarmSetting.getTargetPort()});
            }
            if (sleepTime <= 2000L) continue;
            log.warn("Send {} alarm message to {}:{}, wait {} milliseconds.", new Object[]{alarmMessage.size(), this.alarmSetting.getTargetHost(), this.alarmSetting.getTargetPort(), sleepTime});
            cycle = 2000L;
        }
    }

    private void onGRPCAlarmSettingUpdated(GRPCAlarmSetting grpcAlarmSetting) {
        if (grpcAlarmSetting == null) {
            if (this.grpcClient != null) {
                this.grpcClient.shutdown();
            }
            this.alarmServiceStub = null;
            this.alarmSetting = null;
            log.warn("gRPC alarm hook settings about host is empty, shutdown the old gRPC client.");
            return;
        }
        if (!grpcAlarmSetting.equals(this.alarmSetting)) {
            if (this.grpcClient != null) {
                this.grpcClient.shutdown();
            }
            this.grpcClient = new GRPCClient(grpcAlarmSetting.getTargetHost(), grpcAlarmSetting.getTargetPort());
            this.grpcClient.connect();
            this.alarmServiceStub = AlarmServiceGrpc.newStub((Channel)this.grpcClient.getChannel());
        }
    }
}

